package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public class DealDamageAction implements OnDrinkAction {

    private final float amount;
    private final class_5321<class_8110> source;

    public DealDamageAction(float amount, class_5321<class_8110> source) {
        this.amount = amount;
        this.source = source;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        user.method_5643(user.method_48923().method_48795(source), amount);
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.DEAL_DAMAGE;
    }

    public static class Serializer implements OnDrinkSerializer<DealDamageAction> {

        @Override
        public DealDamageAction fromJson(JsonObject json) {
            class_2960 sourceId = new class_2960(class_3518.method_15265(json, "source"));
            float amount = class_3518.method_15259(json, "amount");
            return new DealDamageAction(amount, class_5321.method_29179(class_7924.field_42534, sourceId));
        }

        @Override
        public void toJson(JsonObject json, DealDamageAction action) {
            json.addProperty("source", action.source.method_29177().toString());
            json.addProperty("amount", action.amount);
        }

        @Override
        public DealDamageAction fromNetwork(class_2540 buf) {
            float amount = buf.readFloat();
            class_5321<class_8110> source = buf.method_44112(class_7924.field_42534);
            return new DealDamageAction(amount, source);
        }

        @Override
        public void toNetwork(class_2540 buf, DealDamageAction action) {
            buf.writeFloat(action.amount);
            buf.method_44116(action.source);
        }
    }

}
