package ml.pluto7073.pdapi.datagen.builder;

import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;

@class_6328
public class WorkstationRecipeBuilder implements class_5797 {

    private final class_1856 base;
    private final class_1856 addition;
    private final class_2960 result;
    private final class_161.class_162 advancement = class_161.class_162.method_51698();

    public WorkstationRecipeBuilder(class_1856 base, class_1856 addition, class_2960 result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    @Override
    public class_5797 method_33530(String criterionName, class_184 criterionTrigger) {
        advancement.method_709(criterionName, criterionTrigger);
        return this;
    }

    @Override
    public class_5797 method_33529(@Nullable String groupName) {
        return this;
    }

    @Override
    public class_1792 method_36441() {
        return addition.method_8105()[0].method_7909();
    }

    @Override
    public void method_17972(Consumer<class_2444> finishedRecipeConsumer, class_2960 recipeId) {
        advancement.method_708(field_39377)
                .method_709("has_the_recipe", class_2119.method_27847(recipeId.method_45138("workstation/")))
                .method_703(class_170.class_171.method_753(recipeId.method_45138("workstation/")))
                .method_704(class_193.field_1257);
        finishedRecipeConsumer.accept(new Result(recipeId, base, addition, result, advancement, recipeId.method_45138("recipes/workstation/")));
    }

    public static class Result implements class_2444 {

        private final class_2960 id;
        private final class_1856 base;
        private final class_1856 addition;
        private final class_2960 result;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public Result(class_2960 id, class_1856 base, class_1856 addition, class_2960 result, class_161.class_162 advancement, class_2960 advancementId) {
            this.id = id;
            this.base = base;
            this.addition = addition;
            this.result = result;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        @Override
        public void method_10416(JsonObject json) {
            json.add("base", base.method_8089());
            json.add("addition", addition.method_8089());
            json.addProperty("result", result.toString());
        }

        @Override
        public class_2960 method_10417() {
            return id;
        }

        @Override
        public class_1865<?> method_17800() {
            return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_SERIALIZER;
        }

        @Override
        public @Nullable JsonObject method_10415() {
            return advancement.method_698();
        }

        @Override
        public @Nullable class_2960 method_10418() {
            return advancementId;
        }
    }

}
