package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ApplyEffectRadiusAction implements OnDrinkAction {

    private static final class_238 ONE_BLOCK = class_2248.method_9541(0, 0, 0, 16, 16, 16).method_1107();

    private final int radius;
    private final boolean includeDrinker;
    private final class_1291 effect;
    private final int duration;
    private final int amplifier;

    public ApplyEffectRadiusAction(int radius, boolean includeDrinker, class_1291 effect, int duration, int amplifier) {
        this.radius = radius;
        this.includeDrinker = includeDrinker;
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        List<class_1309> list =
                level.method_8333(user, ONE_BLOCK.method_1014(radius), entity -> entity instanceof class_1309)
                .stream().map(e -> (class_1309) e).toList();

        for (class_1309 e : list) {
            e.method_6092(new class_1293(effect, duration, amplifier));
        }

        if (includeDrinker) user.method_6092(new class_1293(effect, duration, amplifier));
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.APPLY_EFFECT_RADIUS;
    }

    public static class Serializer implements OnDrinkSerializer<ApplyEffectRadiusAction> {

        public static final Codec<ApplyEffectRadiusAction> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(Codec.INT.fieldOf("radius").forGetter(a -> a.radius),
                                Codec.BOOL.fieldOf("includeDrinker").forGetter(a -> a.includeDrinker),
                                class_7923.field_41174.method_39673().fieldOf("effect").forGetter(a -> a.effect),
                                Codec.INT.fieldOf("duration").forGetter(a -> a.duration),
                                Codec.INT.fieldOf("amplifier").forGetter(a -> a.amplifier))
                        .apply(instance, ApplyEffectRadiusAction::new));

        @Override
        public Codec<ApplyEffectRadiusAction> codec() {
            return CODEC;
        }

        @Override
        public ApplyEffectRadiusAction fromNetwork(class_2540 buf) {
            class_1291 effect = class_7923.field_41174.method_29107(buf.method_44112(class_7924.field_41208));
            int duration = buf.readInt();
            int amplifier = buf.readInt();
            boolean includeDrinker = buf.readBoolean();
            int radius = buf.readInt();
            return new ApplyEffectRadiusAction(radius, includeDrinker, effect, duration, amplifier);
        }

        @Override
        public void toNetwork(class_2540 buf, ApplyEffectRadiusAction action) {
            buf.method_44116(class_7923.field_41174.method_29113(action.effect)
                    .orElseThrow(IllegalStateException::new));
            buf.writeInt(action.duration);
            buf.writeInt(action.amplifier);
            buf.writeBoolean(action.includeDrinker);
            buf.writeInt(action.radius);
        }
    }

}
