package ml.pluto7073.pdapi.client.gui;

import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3914;
import net.minecraft.class_4861;
import net.minecraft.class_6328;
import net.minecraft.class_8047;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.recipes.DrinkWorkstationRecipe;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import java.util.List;
import java.util.Optional;

@class_6328
public class DrinkWorkstationMenu extends class_4861 {

    private final class_1937 world;
    private DrinkWorkstationRecipe currentRecipe;
    private final List<DrinkWorkstationRecipe> recipes;

    public DrinkWorkstationMenu(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public DrinkWorkstationMenu(int syncId, class_1661 playerInventory, class_3914 context) {
        super(PDScreens.WORKSTATION_MENU_TYPE, syncId, playerInventory, context);
        this.world = playerInventory.field_7546.method_37908();
        this.recipes = this.world.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE);
    }

    @Override
    protected boolean method_24927(class_1657 player, boolean present) {
        return currentRecipe != null && currentRecipe.method_8115(field_22480, world);
    }

    @Override
    protected void method_24923(class_1657 player, class_1799 stack) {
        stack.method_7982(player.method_37908(), player, stack.method_7947());
        this.field_22479.method_7664(player, List.of(method_7611(0).method_7677(), method_7611(1).method_7677()));
        decrementStack(0, player);
        decrementStack(1, player);
        field_22481.method_17393((world, pos) -> {
            world.method_20290(10000, pos, 0);
        });
    }

    private void decrementStack(int slot, class_1657 player) {
        class_1799 itemStack = field_22480.method_5438(slot);
        if (itemStack.method_7947() == 1) {
            if (itemStack.method_7909().method_7857()) {
                itemStack = new class_1799(itemStack.method_7909().method_7858(), 1);
            } else {
                itemStack.method_7934(1);
            }
        } else if (itemStack.method_7947() > 1) {
            itemStack.method_7934(1);
            if (itemStack.method_7909().method_7857()) {
                player.method_7270(new class_1799(itemStack.method_7909().method_7858(), 1));
            }
        }
        field_22480.method_5447(slot, itemStack);
    }

    @Override
    protected boolean method_24925(class_2680 state) {
        return state.method_27852(PDBlocks.DRINK_WORKSTATION);
    }

    @Override
    public void method_24928() {
        class_1263 testInput = DrinkUtil.copyContainerContents(field_22480);

        if (field_22480.method_5438(0).method_31574(PDItems.SPECIALTY_DRINK)) {
            testInput.method_5447(0, DrinkUtil.getSpecialDrink(field_22480.method_5438(0)).getBaseItem(field_22480.method_5438(0)));
        }

        List<DrinkWorkstationRecipe> list = world.method_8433().method_17877(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE, testInput, world);
        if (list.isEmpty()) {
            field_22479.method_5447(0, class_1799.field_8037);
        } else {
            currentRecipe = list.get(0);
            class_1799 stack = currentRecipe.craft(field_22480, world);
            field_22479.method_7662(currentRecipe);
            field_22479.method_5447(0, stack);

            // Specialty Drink testing
            class_1263 testResults = DrinkUtil.copyContainerContents(field_22479);
            if (field_22479.method_5438(0).method_31574(PDItems.SPECIALTY_DRINK)) {
                testResults.method_5447(0, DrinkUtil.getSpecialDrink(field_22479.method_5438(0)).getBaseItem(field_22479.method_5438(0)));
            }
            List<SpecialtyDrink> matchingDrinks = SpecialtyDrinkManager.values().stream()
                    .filter(drink -> drink.matches(testResults)).toList();
            if (matchingDrinks.isEmpty()) return;
            SpecialtyDrink drink = matchingDrinks.get(0);
            stack = drink.getAsItem();
            class_2487 data = field_22479.method_5438(0).method_7948().method_10553();
            data.method_10551("Drink");
            data.method_10562(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY)
                            .method_10551(DrinkAdditionManager.ADDITIONS_NBT_KEY);
            data.method_10543(stack.method_7948());
            stack.method_7980(data);
            field_22479.method_5447(0, stack);
        }
    }

    @Override
    protected class_8047 method_48352() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> {
                    boolean fromAdditions = this.recipes.stream().anyMatch(recipe -> recipe.testBase(stack));
                    boolean fromInProgress = this.world.method_8433()
                            .method_30027(PDRecipeTypes.IN_PROGRESS_RECIPE_TYPE)
                            .stream().anyMatch(recipe -> recipe.base().method_8093(stack));
                    return fromAdditions || fromInProgress;
                })
                .method_48374(1, 76, 47, stack -> this.recipes.stream().anyMatch(recipe ->
                        recipe.testAddition(stack)))
                .method_48373(2, 134, 47).method_48372();
    }

    private static Optional<Integer> getQuickMoveSlot(DrinkWorkstationRecipe recipe, class_1799 stack) {
        if (recipe.testBase(stack)) {
            return Optional.of(0);
        } else {
            return recipe.testAddition(stack) ? Optional.of(1) : Optional.empty();
        }
    }

    @Override
    protected boolean method_48356(class_1799 stack) {
        return this.recipes.stream().map((recipe) -> {
            return getQuickMoveSlot(recipe, stack);
        }).anyMatch(Optional::isPresent);
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != field_22479 && super.method_7613(stack, slot);
    }

}
