package ml.pluto7073.pdapi.datagen.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBase;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@class_6328
public abstract class SpecialtyDrinkProvider implements class_2405 {

    private final class_7784.class_7489 drinkPathProvider;

    public SpecialtyDrinkProvider(FabricDataOutput out) {
        this.drinkPathProvider = out.method_45973(class_7784.class_7490.field_39367, "specialty_drinks");
    }

    public abstract void buildDrinks(BiConsumer<class_2960, SpecialtyDrink> output);

    @SuppressWarnings("UnstableApiUsage")
    @Override
    public CompletableFuture<?> method_10319(class_7403 output) {
        Set<class_2960> generated = Sets.newHashSet();
        List<CompletableFuture<?>> list = new ArrayList<>();

        buildDrinks((id, drink) -> {
            if (!generated.add(id))
                throw new IllegalStateException("Duplicate Drink " + id);

            JsonElement json = SpecialtyDrink.CODEC.encodeStart(JsonOps.INSTANCE, drink).getOrThrow(false, s -> {});
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(drink);
            ConditionJsonProvider.write((JsonObject) json, conditions);

            list.add(class_2405.method_10320(output, json, drinkPathProvider.method_44107(id)));
        });

        return CompletableFuture.allOf(list.toArray(CompletableFuture[]::new));
    }

    @Override
    public String method_10321() {
        return "";
    }

    protected static DrinkBuilder builder(SpecialtyDrinkBase base) {
        return new DrinkBuilder(base);
    }

    protected static DrinkBuilder staticBaseBuilder(class_1792 base) {
        return new DrinkBuilder(new SpecialtyDrink.ItemBase(base));
    }

    @SuppressWarnings("UnstableApiUsage")
    protected BiConsumer<class_2960, SpecialtyDrink> withConditions(BiConsumer<class_2960, SpecialtyDrink> output, ConditionJsonProvider... conditions) {
        return (id, drink) -> {
            FabricDataGenHelper.addConditions(drink, conditions);
            output.accept(id, drink);
        };
    }

    public static final class DrinkBuilder {

        private final SpecialtyDrinkBase base;
        private final List<class_2960> additions = new ArrayList<>();
        private final List<OnDrinkAction> actions = new ArrayList<>();
        private int color = -1;
        private double volume = 0;
        private final Map<class_2960, Float> chemicals = new HashMap<>();
        private String name = "";

        public DrinkBuilder(SpecialtyDrinkBase base) {
            this.base = base;
        }

        public DrinkBuilder step(class_2960 id) {
            additions.add(id);
            return this;
        }

        public DrinkBuilder action(OnDrinkAction action) {
            actions.add(action);
            return this;
        }

        public DrinkBuilder color(int color) {
            this.color = color;
            return this;
        }

        public DrinkBuilder chemical(class_2960 id, float amount) {
            chemicals.put(id, amount);
            return this;
        }

        public DrinkBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DrinkBuilder volume(double volume) {
            this.volume = volume;
            return this;
        }

        public void save(class_2960 id, BiConsumer<class_2960, SpecialtyDrink> output) {
            if (color == -1) {
                PDAPI.LOGGER.warn("Drink {} is lacking a color", id);
            }
            if (additions.isEmpty()) {
                throw new IllegalStateException("Drink " + id + " is not craftable");
            }
            output.accept(id, new SpecialtyDrink(base, additions, actions, volume, color, chemicals, name));
        }

    }

}
