package ml.pluto7073.pdapi.item;

import ml.pluto7073.chemicals.item.ChemicalContaining;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6328;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;

@class_6328
public abstract class AbstractCustomizableDrinkItem extends class_1792 implements ChemicalContaining {

    public static final String DRINK_DATA_NBT_KEY = "DrinkData";

    private static final int MAX_USE_TIME = 16;

    protected final class_1792 baseItem;
    protected final double baseVolume;

    protected AbstractCustomizableDrinkItem(class_1792 baseItem, double baseVolume, class_1793 settings) {
        super(settings);
        this.baseVolume = baseVolume;
        this.baseItem = baseItem;
    }

    public double getTotalVolume(class_1799 stack) {
        double vol = baseVolume;
        for (DrinkAddition a : DrinkUtil.getAdditionsFromStack(stack)) {
            vol += a.volume();
        }
        return vol;
    }

    @Override
    public float getChemicalContent(class_2960 name, class_1799 stack) {
        int amount = 0;
        for (DrinkAddition a : DrinkUtil.getAdditionsFromStack(stack)) {
            if (a.getChemicals().containsKey(name))
                amount += a.getChemicals().get(name);
        }
        return amount;
    }

    @Override
    public float getConsumedChemicalContent(class_2960 id, class_1799 stack) {
        float amount = getChemicalContent(id, stack);
        return (float) ((getSipAmount(stack) / 2f) / getTotalVolume(stack)) * amount;
    }

    protected class_1792 baseItem(class_1799 stack) {
        return baseItem;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return MAX_USE_TIME;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282(world, user, hand);
    }

    protected int getSipAmount(class_1799 stack) {
        return getTotalVolume(stack) >= 10 ? 2 : 1;
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 player = user instanceof class_1657 ? (class_1657) user : null;

        if (player != null) {
            stack.method_7956(getSipAmount(stack), player, p -> {});
        }

        if (!stack.method_7960()) return stack;

        if (player instanceof class_3222) {
            class_174.field_1198.method_8821((class_3222)player, stack);
        }

        if (!world.field_9236) {
            DrinkAddition[] additions = DrinkUtil.getAdditionsFromStack(stack);
            for (DrinkAddition addition : additions) {
                addition.onDrink(stack, world, user);
            }
        }

        if (player != null) {
            player.method_7259(class_3468.field_15372.method_14956(this));
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }

        if (player == null || !player.method_31549().field_7477) {
            if (stack.method_7960()) {
                return new class_1799(baseItem(stack));
            }

            if (player != null) {
                player.method_31548().method_7394(new class_1799(baseItem(stack)));
            }
        }
        user.method_32876(class_5712.field_28734);
        return stack;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        DrinkAddition[] addIns = DrinkUtil.getAdditionsFromStack(stack);
        HashMap<class_2960, Integer> additionCounts = new HashMap<>();
        for (DrinkAddition addIn : addIns) {
            if (addIn == DrinkAdditionManager.EMPTY || addIn == null) continue;
            class_2960 id = DrinkAdditionManager.getId(addIn);
            if (additionCounts.containsKey(id)) {
                int count = additionCounts.get(id);
                additionCounts.put(id, ++count);
            } else additionCounts.put(id, 1);
        }
        additionCounts.forEach((id, count) -> tooltip.add(class_2561.method_43469(DrinkAdditionManager.get(id).getTranslationKey(), count).method_27692(class_124.field_1080)));
    }

    @Override
    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float) stack.method_7919() * 13.0f / (float) stack.method_7936());
    }

    @Override
    public int method_31571(class_1799 stack) {
        return 0x25bbf7;
    }
}
