/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.datagen.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBase;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

@class_6328
public abstract class SpecialtyDrinkProvider
implements class_2405 {
    private final class_7784.class_7489 drinkPathProvider;

    public SpecialtyDrinkProvider(FabricDataOutput out) {
        this.drinkPathProvider = out.method_45973(class_7784.class_7490.field_39367, "specialty_drinks");
    }

    public abstract void buildDrinks(BiConsumer<class_2960, SpecialtyDrink> var1);

    public CompletableFuture<?> method_10319(class_7403 output) {
        HashSet generated = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.buildDrinks((id, drink) -> {
            if (!generated.add(id)) {
                throw new IllegalStateException("Duplicate Drink " + id);
            }
            JsonElement json = (JsonElement)SpecialtyDrink.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, drink).getOrThrow(false, s -> {});
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions((Object)drink);
            ConditionJsonProvider.write((JsonObject)((JsonObject)json), (ConditionJsonProvider[])conditions);
            list.add(class_2405.method_10320((class_7403)output, (JsonElement)json, (Path)this.drinkPathProvider.method_44107(id)));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return "";
    }

    protected static DrinkBuilder builder(SpecialtyDrinkBase base) {
        return new DrinkBuilder(base);
    }

    protected static DrinkBuilder staticBaseBuilder(class_1792 base) {
        return new DrinkBuilder(new SpecialtyDrink.ItemBase(base));
    }

    protected BiConsumer<class_2960, SpecialtyDrink> withConditions(BiConsumer<class_2960, SpecialtyDrink> output, ConditionJsonProvider ... conditions) {
        return (id, drink) -> {
            FabricDataGenHelper.addConditions((Object)drink, (ConditionJsonProvider[])conditions);
            output.accept((class_2960)id, (SpecialtyDrink)drink);
        };
    }

    public static final class DrinkBuilder {
        private final SpecialtyDrinkBase base;
        private final List<class_2960> additions = new ArrayList<class_2960>();
        private final List<OnDrinkAction> actions = new ArrayList<OnDrinkAction>();
        private int color = -1;
        private double volume = 0.0;
        private final Map<class_2960, Float> chemicals = new HashMap<class_2960, Float>();
        private String name = "";

        public DrinkBuilder(SpecialtyDrinkBase base) {
            this.base = base;
        }

        public DrinkBuilder step(class_2960 id) {
            this.additions.add(id);
            return this;
        }

        public DrinkBuilder action(OnDrinkAction action) {
            this.actions.add(action);
            return this;
        }

        public DrinkBuilder color(int color) {
            this.color = color;
            return this;
        }

        public DrinkBuilder chemical(class_2960 id, float amount) {
            this.chemicals.put(id, Float.valueOf(amount));
            return this;
        }

        public DrinkBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DrinkBuilder volume(double volume) {
            this.volume = volume;
            return this;
        }

        public void save(class_2960 id, BiConsumer<class_2960, SpecialtyDrink> output) {
            if (this.color == -1) {
                PDAPI.LOGGER.warn("Drink {} is lacking a color", (Object)id);
            }
            if (this.additions.isEmpty()) {
                throw new IllegalStateException("Drink " + id + " is not craftable");
            }
            output.accept(id, new SpecialtyDrink(this.base, this.additions, this.actions, this.volume, this.color, this.chemicals, this.name));
        }
    }
}

