package ml.pluto7073.pdapi.item;

import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;

@class_6328
public class SpecialtyDrinkItem extends AbstractCustomizableDrinkItem {

    protected SpecialtyDrinkItem(class_1793 settings) {
        super(class_1802.field_8469, 0, settings);
    }

    @Override
    protected class_1792 baseItem(class_1799 stack) {
        SpecialtyDrink drink = DrinkUtil.getSpecialDrink(stack);
        AbstractCustomizableDrinkItem base =
                (AbstractCustomizableDrinkItem) drink.getBaseItem(stack).method_7909();
        return base.baseItem(stack);
    }

    @Override
    public double getTotalVolume(class_1799 stack) {
        try {
            SpecialtyDrink specialty = DrinkUtil.getSpecialDrink(stack);
            if (specialty.volume() != 0) {
                return specialty.volume();
            }
            class_1799 baseItem = specialty.getBaseItem(stack);
            if (baseItem.method_7909() instanceof AbstractCustomizableDrinkItem drink) {
                return drink.getTotalVolume(baseItem);
            } else {
                return super.getTotalVolume(stack);
            }
        } catch (Exception e) {
            PDAPI.LOGGER.warn("Error getting total volume of {}", stack, e);
            return 0;
        }
    }

    @Override
    public float getChemicalContent(class_2960 name, class_1799 stack) {
        float amount;
        try {
            SpecialtyDrink specialty = DrinkUtil.getSpecialDrink(stack);
            amount = specialty.chemicals().getOrDefault(name, 0f);
            class_1799 baseItem = specialty.getBaseItem(stack);
            if (baseItem.method_7909() instanceof AbstractCustomizableDrinkItem drink) {
                return amount + drink.getChemicalContent(name, baseItem);
            } else {
                return super.getChemicalContent(name, stack) + amount;
            }
        } catch (Exception e) {
            PDAPI.LOGGER.warn("Error getting amount of {} in {}", name, stack, e);
            return 0;
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 user) {
        SpecialtyDrink drink = DrinkUtil.getSpecialDrink(stack);

        if (!level.field_9236) drink.actions().forEach(action -> action.onDrink(stack, level, user));

        return super.method_7861(stack, level, user);
    }

    @Override
    public String method_7866(class_1799 stack) {
        try {
            SpecialtyDrink drink = DrinkUtil.getSpecialDrink(stack);
            return drink.name();
        } catch (Exception e) {
            return super.method_7866(stack);
        }
    }

}
