package ml.pluto7073.pdapi.mixin.client;

import ml.pluto7073.pdapi.addition.chemicals.CaffeineHandler;
import ml.pluto7073.pdapi.config.PDClientConfig;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_583;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_922.class)
public class LivingEntityRendererMixin<
        T extends class_1309,
        M extends class_583<T>> {

    @Inject(at = @At("RETURN"), method = "isShaking", cancellable = true)
    public void pdapi$caffeineShakes(T entity, CallbackInfoReturnable<Boolean> cir) {
        if (!(entity instanceof class_1657 playerEntity)
            || !PDClientConfig.INSTANCE.doCaffeineShake) return;
        float caffeine = CaffeineHandler.INSTANCE.get(playerEntity);
        if (caffeine >= PDClientConfig.INSTANCE.caffeineShakeThreshold) {
            cir.setReturnValue(true);
        }
    }

}
