/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.specialty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBase;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBaseSerializer;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@class_6328
public class SpecialtyDrink {
    public static final Codec<SpecialtyDrink> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpecialtyDrinkBase.CODEC.fieldOf("base").forGetter(SpecialtyDrink::base), (App)Codec.list((Codec)class_2960.field_25139).fieldOf("additions").forGetter(SpecialtyDrink::steps), (App)Codec.list(OnDrinkAction.CODEC).fieldOf("onDrinkActions").forGetter(drink -> List.of(drink.actions)), (App)Codec.DOUBLE.fieldOf("volume").orElse((Object)0.0).forGetter(SpecialtyDrink::volume), (App)Codec.INT.fieldOf("color").orElse((Object)-1).forGetter(SpecialtyDrink::color), (App)Codec.simpleMap((Codec)class_2960.field_25139, (Codec)Codec.FLOAT, (Keyable)Chemicals.REGISTRY).fieldOf("chemicals").orElse(Map.of()).forGetter(SpecialtyDrink::chemicals), (App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(drink -> drink.name)).apply((Applicative)instance, SpecialtyDrink::new));
    private final SpecialtyDrinkBase base;
    private final class_2960[] steps;
    private final OnDrinkAction[] actions;
    private final double volume;
    private final int color;
    private final Map<class_2960, Float> chemicals;
    private final String name;

    public SpecialtyDrink(SpecialtyDrinkBase base, List<class_2960> steps, List<OnDrinkAction> actions, double volume, int color, Map<class_2960, Float> chemicals, @Nullable String name) {
        this.base = base;
        this.steps = (class_2960[])steps.toArray(class_2960[]::new);
        this.actions = (OnDrinkAction[])actions.toArray(OnDrinkAction[]::new);
        this.volume = volume;
        this.color = color;
        this.chemicals = chemicals;
        this.name = name == null ? "" : name;
    }

    public String languageKey() {
        return this.id().method_42093("drink");
    }

    public class_2960 id() {
        return SpecialtyDrinkManager.getId(this);
    }

    public SpecialtyDrinkBase base() {
        return this.base;
    }

    public List<class_2960> steps() {
        return List.of(this.steps);
    }

    public List<OnDrinkAction> actions() {
        ArrayList<OnDrinkAction> stepActions = new ArrayList<OnDrinkAction>();
        for (class_2960 step : this.steps) {
            stepActions.addAll(DrinkAdditionManager.get(step).actions());
        }
        stepActions.addAll(List.of(this.actions));
        return ImmutableList.copyOf(stepActions);
    }

    public double volume() {
        return this.volume;
    }

    public int color() {
        return this.color;
    }

    public Map<class_2960, Float> chemicals() {
        return this.chemicals;
    }

    public String name() {
        return this.name == null || this.name.isEmpty() ? this.languageKey() : this.name;
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799((class_1935)PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getBaseItem(class_1799 source) {
        class_1799 stack = this.base.buildItemStack();
        class_2487 ogData = source.method_7911("DrinkData");
        class_2487 newData = source.method_7948().method_10553();
        newData.method_10551("Drink");
        class_2487 drinkData = newData.method_10562("DrinkData");
        class_2499 list = new class_2499();
        for (class_2960 step : this.steps) {
            list.add((Object)class_2519.method_23256((String)step.toString()));
        }
        list.addAll((Collection)ogData.method_10554("Additions", 8));
        drinkData.method_10566("Additions", (class_2520)list);
        stack.method_7980(newData);
        return stack;
    }

    public boolean matches(class_1263 container) {
        class_1799 currentResult = container.method_5438(0);
        if (!this.base.matches(currentResult)) {
            return false;
        }
        class_2499 additions = currentResult.method_7911("DrinkData").method_10554("Additions", 8);
        if (this.steps.length != additions.size()) {
            return false;
        }
        for (int i = 0; i < additions.size(); ++i) {
            String wanted;
            String actual = additions.method_10608(i);
            if (actual.equals(wanted = this.steps[i].toString())) continue;
            return false;
        }
        return true;
    }

    public List<class_1856> stepsToIngredientList() {
        ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
        for (class_2960 addition : this.steps) {
            ingredients.add(DrinkUtil.additionToIngredient(addition));
        }
        return ingredients;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10812(PDRegistries.SPECIALTY_DRINK_BASE.method_10221((Object)this.base.serializer()));
        this.base.serializer().toNetwork(buf, this.base);
        NetworkingUtils.arrayToNetwork(buf, this.steps, class_2540::method_10812);
        buf.method_34063(this.chemicals, class_2540::method_10812, class_2540::writeFloat);
        buf.writeDouble(this.volume);
        buf.writeInt(this.color);
        NetworkingUtils.writeDrinkActionsList(buf, this.actions);
        buf.method_10814(this.name);
    }

    public static SpecialtyDrink fromNetwork(class_2540 buf) {
        class_2960 baseSerializer = buf.method_10810();
        SpecialtyDrinkBase base = ((SpecialtyDrinkBaseSerializer)PDRegistries.SPECIALTY_DRINK_BASE.method_17966(baseSerializer).orElseThrow()).fromNetwork(buf);
        List<class_2960> steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810);
        HashMap chemicals = Maps.newHashMap((Map)buf.method_34067(class_2540::method_10810, class_2540::readFloat));
        double volume = buf.readDouble();
        int color = buf.readInt();
        List<OnDrinkAction> list = NetworkingUtils.readDrinkActionsList(buf);
        String name = buf.method_19772();
        return new SpecialtyDrink(base, steps, list, volume, color, chemicals, name);
    }

    public static class ItemBaseSerializer
    implements SpecialtyDrinkBaseSerializer {
        public static final Codec<ItemBase> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("item").forGetter(base -> base.item)).apply((Applicative)instance, ItemBase::new));

        @Override
        public Codec<? extends SpecialtyDrinkBase> codec() {
            return CODEC;
        }

        @Override
        public void toNetwork(class_2540 buf, SpecialtyDrinkBase base) {
            if (!(base instanceof ItemBase)) {
                throw new IllegalStateException();
            }
            ItemBase item = (ItemBase)base;
            buf.method_10812(class_7923.field_41178.method_10221((Object)item.item));
        }

        @Override
        public SpecialtyDrinkBase fromNetwork(class_2540 buf) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(buf.method_10810());
            return new ItemBase(item);
        }
    }

    public static class ItemBase
    implements SpecialtyDrinkBase {
        private final class_1792 item;

        public ItemBase(class_1792 item) {
            this.item = item;
        }

        @Override
        public class_1799 buildItemStack() {
            return new class_1799((class_1935)this.item);
        }

        @Override
        public boolean matches(class_1799 stack) {
            return stack.method_31574(this.item);
        }

        @Override
        public SpecialtyDrinkBaseSerializer serializer() {
            return SpecialtyDrinkBaseSerializer.ITEM_BASE;
        }
    }
}

