package ml.pluto7073.pdapi;

import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializers;
import ml.pluto7073.pdapi.addition.chemicals.CaffeineHandler;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.client.gui.PDScreens;
import ml.pluto7073.pdapi.config.PDCommonConfig;
import ml.pluto7073.pdapi.entity.effect.PDMobEffects;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBaseSerializer;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.pdapi.util.DrinkUtil;
import ml.pluto7073.plutonium.PlutoniumConfig;
import ml.pluto7073.plutonium.config.ServerConfigType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PDAPI implements ModInitializer {

    public static final String ID = "pdapi";
    public static final Logger LOGGER = LogManager.getLogger("PDAPI");
    public static final class_5321<class_1761> SPECIALTY_DRINKS_TAB = class_5321.method_29179(class_7924.field_44688, asId("specialty_drinks"));
    public static final ServerConfigType<PDCommonConfig> CONFIG_TYPE =
            class_2378.method_10230(PlutoniumConfig.SERVER_CONFIG_TYPES, asId("common"), new ServerConfigType<>(PDCommonConfig.INSTANCE, PDCommonConfig::new));


    @Override
    public void onInitialize() {
        OnDrinkSerializers.init();
        SpecialtyDrinkBaseSerializer.init();
        PDRecipeTypes.init();
        CaffeineHandler.init();
        PDBlocks.init();
        PDItems.init();
        PDMobEffects.init();

        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new DrinkAdditionManager());
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new SpecialtyDrinkManager());

        DrinkUtil.registerOldToNewConverter("Coffee/Additions", tag -> {
            if (!(tag instanceof class_2499 list)) return tag;
            if (list.isEmpty()) return list;
            for (int i = 0; i < list.size(); i++) {
                class_2960 id = new class_2960(list.method_10608(i));
                boolean ogCoffee = !DrinkAdditionManager.containsId(id) && DrinkAdditionManager.containsId(PDAPI.asId(id.method_12832()));
                if (!ogCoffee) continue;
                id = PDAPI.asId(id.method_12832());
                list.method_10606(i, DrinkUtil.stringAsNbt(id.toString()));
            }
            return list;
        });

        PDScreens.init();

        class_2378.method_39197(class_7923.field_44687, SPECIALTY_DRINKS_TAB, FabricItemGroup.builder().method_47320(() -> new class_1799(PDItems.MILK_BOTTLE))
                .method_47321(class_2561.method_43471("creative_tab.pdapi.specialty_drinks")).method_47324());
        ItemGroupEvents.modifyEntriesEvent(SPECIALTY_DRINKS_TAB).register(stacks -> {
            for (SpecialtyDrink d : SpecialtyDrinkManager.values()
                    .stream().sorted(DrinkUtil.alphabetizer(SpecialtyDrink::languageKey)).toList()) {
                stacks.method_45420(d.getAsItem());
            }
        });

        LOGGER.info("Pluto's Drinks API ready!");
    }

    public static class_2960 asId(String name) {
        return new class_2960(ID, name);
    }

}
