package ml.pluto7073.pdapi.recipes;

import com.google.gson.JsonObject;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import net.minecraft.world.item.crafting.*;

@class_6328
public record InProgressItemRecipe(class_2960 id, class_1856 base, class_1799 result) implements class_1860<class_1263> {

    /**
     * Constructs a new Recipe for an In Progress item
     * @param id The recipe ID
     * @param base The base ingredient to convert
     * @param result The resulting in progress AbstractCustomizableDrinkItem
     */
    public InProgressItemRecipe {}

    @Override
    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return base.method_8093(inventory.method_5438(0));
    }

    @Override
    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        class_1799 result = result().method_7972();

        result.method_7948().method_10582("FromItem",
                class_7923.field_41178.method_10221(inventory.method_5438(0).method_7909()).toString());

        return result;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        return result;
    }

    @Override
    public class_2960 method_8114() {
        return id;
    }

    @Override
    public class_1865<?> method_8119() {
        return PDRecipeTypes.IN_PROGRESS_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return PDRecipeTypes.IN_PROGRESS_RECIPE_TYPE;
    }

    public static class Serializer implements class_1865<InProgressItemRecipe> {

        @Override
        public InProgressItemRecipe method_8121(class_2960 id, JsonObject json) {
            class_1856 baseItem = class_1856.method_52177(class_3518.method_15296(json, "base"));
            class_1799 resultStack = class_1869.method_35228(
                    class_3518.method_15296(json, "result"));
            resultStack.method_7939(1);
            return new InProgressItemRecipe(id, baseItem, resultStack);
        }

        @Override
        public InProgressItemRecipe method_8122(class_2960 id, class_2540 buf) {
            class_1856 baseItem = class_1856.method_8086(buf);
            class_1799 result = buf.method_10819();
            return new InProgressItemRecipe(id, baseItem, result);
        }

        @Override
        public void toNetwork(class_2540 buf, InProgressItemRecipe recipe) {
            recipe.base.method_8088(buf);
            buf.method_10793(recipe.result);
        }
    }

}
