package ml.pluto7073.pdapi.util;

import ml.pluto7073.pdapi.PDAPI;
import net.minecraft.class_2960;
import java.util.HashMap;
import java.util.Map;

public class PseudoDataFixerRegistry {

    private static final Map<class_2960, class_2960> REGISTRY = new HashMap<>();

    public static boolean shouldFix(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static void register(class_2960 oldId, class_2960 newId) {
        REGISTRY.put(oldId, newId);
    }

    public static class_2960 getReplacement(class_2960 id) {
        return REGISTRY.getOrDefault(id, new class_2960("empty"));
    }

    static {
        REGISTRY.put(new class_2960("plutoscoffee:milk_bottle"), PDAPI.asId("milk_bottle"));
        REGISTRY.put(new class_2960("plutoscoffee:coffee_workstation"), PDAPI.asId("drink_workstation"));
    }

}
