/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Logger;

@Deprecated(forRemoval=true)
public abstract class BaseConfig {
    protected Properties properties;
    protected String modid;
    protected String name;
    protected Logger logger;

    public BaseConfig(String modid, String name, Logger logger) {
        this.modid = modid;
        this.name = name;
        this.logger = logger;
        this.properties = new Properties();
        this.initConfig();
        this.load();
    }

    public abstract void initConfig();

    public void load() {
        File configDir = new File(FabricLoader.getInstance().getGameDir().toFile(), "config");
        File configFile = new File(configDir, this.modid + "_" + this.name + ".properties");
        if (!configFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            this.properties.load(reader);
        }
        catch (IOException e) {
            this.logger.error("Couldn't load {} config for {}", (Object)this.modid, (Object)this.name, (Object)e);
        }
    }

    public void save() {
        File configDir = new File(FabricLoader.getInstance().getGameDir().toFile(), "config");
        File configFile = new File(configDir, this.modid + "_" + this.name + ".properties");
        if (!configFile.exists()) {
            try {
                if (!configFile.createNewFile()) {
                    throw new IOException("File already exists");
                }
            }
            catch (IOException e) {
                this.logger.error("Couldn't create {} config file for {}", (Object)this.modid, (Object)this.name, (Object)e);
            }
        }
        try (FileWriter writer = new FileWriter(configFile);){
            this.properties.store(writer, "");
        }
        catch (IOException e) {
            this.logger.error("Couldn't save {} config for {}", (Object)this.modid, (Object)this.name, (Object)e);
        }
    }

    protected void setInt(String key, int i) {
        this.properties.setProperty(key, String.valueOf(i));
    }

    protected void setFloat(String key, float f) {
        this.properties.setProperty(key, String.valueOf(f));
    }

    protected void setBoolean(String key, boolean b) {
        this.properties.setProperty(key, String.valueOf(b));
    }

    protected <T extends Enum<T>> void setEnum(String key, T value) {
        this.properties.setProperty(key, value.name());
    }

    protected int getInt(String key) {
        return Integer.parseInt(this.properties.getProperty(key));
    }

    protected float getFloat(String key) {
        return Float.parseFloat(this.properties.getProperty(key));
    }

    protected boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    protected <T extends Enum<T>> T getEnum(String key, Class<T> enumClass) {
        return Enum.valueOf(enumClass, this.properties.getProperty(key));
    }
}

