package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.pdapi.networking.packet.clientbound.ClientboundSyncAdditionRegistryPacket;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;

public class DrinkAdditionManager implements SimpleSynchronousResourceReloadListener {

    private static final Map<class_2960, DrinkAddition> REGISTRY = new HashMap<>();
    private static final Map<class_2960, DrinkAddition> STATIC_REGISTRY = new HashMap<>();

    public static final String ADDITIONS_NBT_KEY = "Additions";
    public static final DrinkAddition EMPTY = register(PDAPI.asId("empty"), new DrinkAddition.Builder().build());
    public static final class_2960 PHASE = PDAPI.asId("phase/additions");

    public DrinkAdditionManager() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> send(player));
    }

    public static DrinkAddition register(class_2960 id, DrinkAddition addition) {
        return register(id, addition, true);
    }

    public static DrinkAddition register(class_2960 id, DrinkAddition addition, boolean staticAdd) {
        if (containsId(id)) {
            if (get(id).getCurrentWeight() >= addition.getCurrentWeight()) return get(id);
        }
        REGISTRY.put(id, addition);
        if (staticAdd) STATIC_REGISTRY.put(id, addition);
        return addition;
    }

    public static class_2960 getId(DrinkAddition addition) {
        for (Map.Entry<class_2960, DrinkAddition> entry : REGISTRY.entrySet()) {
            if (addition.equals(entry.getValue())) {
                return entry.getKey();
            }
        }
        throw new IllegalArgumentException("Unregistered drink addition: " + addition.toString());
    }

    public static DrinkAddition get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static void resetRegistry() {
        REGISTRY.clear();
        REGISTRY.putAll(STATIC_REGISTRY);
    }

    public static boolean containsId(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static boolean containsAddition(DrinkAddition addition) {
        return REGISTRY.containsValue(addition);
    }

    public static boolean contains(class_2960 id, DrinkAddition addition) {
        return containsId(id) && containsAddition(addition) && get(id).equals(addition);
    }

    public static boolean contains(Map.Entry<class_2960, DrinkAddition> entry) {
        return contains(entry.getKey(), entry.getValue());
    }

    public static void send(class_3222 entity) {

        ServerPlayNetworking.send(entity, new ClientboundSyncAdditionRegistryPacket(REGISTRY));

    }

    @Override
    public class_2960 getFabricId() {
        return PDAPI.asId("drink_addition_registerer");
    }

    @Override
    public void method_14491(class_3300 manager) {
        resetRegistry();

        int i = 0;

        for (Map.Entry<class_2960, class_3298> entry : manager.method_14488("drink_additions", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = DrinkUtil.getAsId(entry.getKey(), "drink_additions");
            try (InputStream stream = entry.getValue().method_14482()) {
                JsonObject object = class_3518.method_15255(new InputStreamReader(stream));

                if (object.has("fabric:load_conditions")) {
                    boolean b = ResourceConditions.conditionsMatch(
                            class_3518.method_15261(object, "fabric:load_conditions"),
                            true
                    );

                    if (!b) continue;
                }

                register(id, loadFromJson(id, object), false);
                i++;
            } catch (IOException e) {
                PDAPI.LOGGER.error("Could not load Drink Addition {}", id, e);
            }
        }

        PDAPI.LOGGER.info("Loaded {} additions", i);
    }

    @Override
    public ArrayList<class_2960> getFabricDependencies() {
        return new ArrayList<>();
    }

    public static DrinkAddition loadFromJson(class_2960 id, JsonObject object) {
        DrinkAddition.Builder builder = new DrinkAddition.Builder();
        Chemicals.REGISTRY.forEach(handler -> {
            class_2960 name = handler.getId();
            if (object.has(name.toString())) {
                builder.chemical(name, class_3518.method_15260(object, name.toString()));
            }
        });
        if (object.has("changesColor")) {
            builder.changesColor(class_3518.method_15270(object, "changesColor"));
        }
        if (object.has("color")) {
            builder.color(class_3518.method_15260(object, "color"));
        }
        if (object.has("maxAmount")) {
            builder.maxAmount(class_3518.method_15260(object, "maxAmount"));
        }
        if (object.has("onDrinkActions")) {
            JsonArray actionsArray = class_3518.method_15261(object, "onDrinkActions");
            for (JsonElement e : actionsArray) {
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Drink Addition file: {}", id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                class_2960 type =
                        new class_2960(class_3518.method_15265(actionObject, "type"));
                OnDrinkSerializer<?> template = PDRegistries.ON_DRINK_SERIALIZER.method_10223(type);
                if (template == null) {
                    PDAPI.LOGGER.error("Could not load OnDrinkAction for add-in {} because of non-existent OnDrinkTemplate {}", id.toString(), class_3518.method_15265(actionObject, "type"));
                    continue;
                }
                try {
                    OnDrinkAction action = template.fromJson(actionObject);
                    builder.addAction(action);
                } catch (Exception ex) {
                    PDAPI.LOGGER.error("Could not load OnDrinkAction for addition {}", id, new RuntimeException(ex));
                }
            }
        }
        if (object.has("weight")) {
            builder.setWeight(class_3518.method_15260(object, "weight"));
        }
        if (object.has("name")) {
            builder.name(class_3518.method_15265(object, "name"));
        }

        return builder.build();
    }

}
