package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class ApplyStatusEffectAction implements OnDrinkAction {

    private final class_1291 effect;
    private final int duration, amplifier;

    public ApplyStatusEffectAction(class_1291 effect, int duration, int amplifier) {
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        user.method_6092(new class_1293(effect, duration, amplifier));
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.APPLY_STATUS_EFFECT;
    }

    public static class Serializer implements OnDrinkSerializer<ApplyStatusEffectAction> {

        @Override
        public ApplyStatusEffectAction fromJson(JsonObject json) {
            class_2960 effectId = new class_2960(class_3518.method_15265(json, "effect"));
            int duration = class_3518.method_15260(json, "duration");
            int amplifier = class_3518.method_15260(json, "amplifier");
            class_1291 effect = class_7923.field_41174.method_10223(effectId);
            if (effect == null) {
                throw new IllegalArgumentException("Effect ID must point to a Mob Effect that actually exists");
            }
            return new ApplyStatusEffectAction(effect, duration, amplifier);
        }

        @Override
        public void toJson(JsonObject json, ApplyStatusEffectAction action) {
            class_2960 id = class_7923.field_41174.method_10221(action.effect);
            if (id == null) throw new IllegalStateException();
            json.addProperty("effect", id.toString());
            json.addProperty("duration", action.duration);
            json.addProperty("amplifier", action.amplifier);
        }

        @Override
        public ApplyStatusEffectAction fromNetwork(class_2540 buf) {
            class_2960 id = buf.method_10810();
            class_1291 effect = class_7923.field_41174.method_10223(id);
            if (effect == null) throw new IllegalStateException();
            int duration = buf.readInt();
            int amplifier = buf.readInt();
            return new ApplyStatusEffectAction(effect, duration, amplifier);
        }

        @Override
        public void toNetwork(class_2540 buf, ApplyStatusEffectAction action) {
            class_2960 id = class_7923.field_41174.method_10221(action.effect);
            if (id == null) throw new IllegalStateException();
            buf.method_10812(id);
            buf.writeInt(action.duration);
            buf.writeInt(action.amplifier);
        }
    }

}
