/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.pdapi.networking.packet.clientbound.ClientboundSyncAdditionRegistryPacket;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class DrinkAdditionManager
implements SimpleSynchronousResourceReloadListener {
    private static final Map<class_2960, DrinkAddition> REGISTRY = new HashMap<class_2960, DrinkAddition>();
    private static final Map<class_2960, DrinkAddition> STATIC_REGISTRY = new HashMap<class_2960, DrinkAddition>();
    public static final String ADDITIONS_NBT_KEY = "Additions";
    public static final DrinkAddition EMPTY = DrinkAdditionManager.register(PDAPI.asId("empty"), new DrinkAddition.Builder().build());
    public static final class_2960 PHASE = PDAPI.asId("phase/additions");

    public DrinkAdditionManager() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> DrinkAdditionManager.send(player));
    }

    public static DrinkAddition register(class_2960 id, DrinkAddition addition) {
        return DrinkAdditionManager.register(id, addition, true);
    }

    public static DrinkAddition register(class_2960 id, DrinkAddition addition, boolean staticAdd) {
        if (DrinkAdditionManager.containsId(id) && DrinkAdditionManager.get(id).getCurrentWeight() >= addition.getCurrentWeight()) {
            return DrinkAdditionManager.get(id);
        }
        REGISTRY.put(id, addition);
        if (staticAdd) {
            STATIC_REGISTRY.put(id, addition);
        }
        return addition;
    }

    public static class_2960 getId(DrinkAddition addition) {
        for (Map.Entry<class_2960, DrinkAddition> entry : REGISTRY.entrySet()) {
            if (!addition.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unregistered drink addition: " + addition.toString());
    }

    public static DrinkAddition get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static void resetRegistry() {
        REGISTRY.clear();
        REGISTRY.putAll(STATIC_REGISTRY);
    }

    public static boolean containsId(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static boolean containsAddition(DrinkAddition addition) {
        return REGISTRY.containsValue(addition);
    }

    public static boolean contains(class_2960 id, DrinkAddition addition) {
        return DrinkAdditionManager.containsId(id) && DrinkAdditionManager.containsAddition(addition) && DrinkAdditionManager.get(id).equals(addition);
    }

    public static boolean contains(Map.Entry<class_2960, DrinkAddition> entry) {
        return DrinkAdditionManager.contains(entry.getKey(), entry.getValue());
    }

    public static void send(class_3222 entity) {
        ServerPlayNetworking.send((class_3222)entity, (FabricPacket)new ClientboundSyncAdditionRegistryPacket(REGISTRY));
    }

    public class_2960 getFabricId() {
        return PDAPI.asId("drink_addition_registerer");
    }

    public void method_14491(class_3300 manager) {
        DrinkAdditionManager.resetRegistry();
        int i = 0;
        for (Map.Entry entry : manager.method_14488("drink_additions", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id2 = DrinkUtil.getAsId((class_2960)entry.getKey(), "drink_additions");
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    boolean b;
                    JsonObject object = class_3518.method_15255((Reader)new InputStreamReader(stream));
                    if (object.has("fabric:load_conditions") && !(b = ResourceConditions.conditionsMatch((JsonArray)class_3518.method_15261((JsonObject)object, (String)"fabric:load_conditions"), (boolean)true))) continue;
                    DrinkAdditionManager.register(id2, DrinkAdditionManager.loadFromJson(id2, object), false);
                    ++i;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                PDAPI.LOGGER.error("Could not load Drink Addition {}", (Object)id2, (Object)e);
            }
        }
        PDAPI.LOGGER.info("Loaded {} additions", (Object)i);
    }

    public ArrayList<class_2960> getFabricDependencies() {
        return new ArrayList<class_2960>();
    }

    public static DrinkAddition loadFromJson(class_2960 id, JsonObject object) {
        DrinkAddition.Builder builder = new DrinkAddition.Builder();
        Chemicals.REGISTRY.forEach(handler -> {
            class_2960 name = handler.getId();
            if (object.has(name.toString())) {
                builder.chemical(name, class_3518.method_15260((JsonObject)object, (String)name.toString()));
            }
        });
        if (object.has("changesColor")) {
            builder.changesColor(class_3518.method_15270((JsonObject)object, (String)"changesColor"));
        }
        if (object.has("color")) {
            builder.color(class_3518.method_15260((JsonObject)object, (String)"color"));
        }
        if (object.has("maxAmount")) {
            builder.maxAmount(class_3518.method_15260((JsonObject)object, (String)"maxAmount"));
        }
        if (object.has("onDrinkActions")) {
            JsonArray actionsArray = class_3518.method_15261((JsonObject)object, (String)"onDrinkActions");
            for (JsonElement e : actionsArray) {
                if (!e.isJsonObject()) {
                    PDAPI.LOGGER.warn("Non-JsonObject item in 'onDrinkActions' in Drink Addition file: {}", (Object)id);
                    continue;
                }
                JsonObject actionObject = e.getAsJsonObject();
                class_2960 type = new class_2960(class_3518.method_15265((JsonObject)actionObject, (String)"type"));
                OnDrinkSerializer template = (OnDrinkSerializer)PDRegistries.ON_DRINK_SERIALIZER.method_10223(type);
                if (template == null) {
                    PDAPI.LOGGER.error("Could not load OnDrinkAction for add-in {} because of non-existent OnDrinkTemplate {}", (Object)id.toString(), (Object)class_3518.method_15265((JsonObject)actionObject, (String)"type"));
                    continue;
                }
                try {
                    Object action = template.fromJson(actionObject);
                    builder.addAction((OnDrinkAction)action);
                }
                catch (Exception ex) {
                    PDAPI.LOGGER.error("Could not load OnDrinkAction for addition {}", (Object)id, (Object)new RuntimeException(ex));
                }
            }
        }
        if (object.has("weight")) {
            builder.setWeight(class_3518.method_15260((JsonObject)object, (String)"weight"));
        }
        if (object.has("name")) {
            builder.name(class_3518.method_15265((JsonObject)object, (String)"name"));
        }
        return builder.build();
    }
}

