package ml.pluto7073.pdapi.addition.chemicals;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import ml.pluto7073.chemicals.Chemicals;
import ml.pluto7073.chemicals.handlers.HalfLifeChemicalHandler;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.entity.effect.PDMobEffects;
import ml.pluto7073.pdapi.gamerule.PDGameRules;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CaffeineHandler extends HalfLifeChemicalHandler {

    public static final CaffeineHandler INSTANCE = new CaffeineHandler(2500);

    public CaffeineHandler(int halfLifeTicks) {
        super(halfLifeTicks);
    }

    @Override
    public Collection<class_1293> getEffectsForAmount(float amount, class_1937 level) {
        ArrayList<class_1293> list = new ArrayList<>();
        if (amount >= 100) {
            list.add(new class_1293(class_1294.field_5904, 600));
        }
        if (amount >= 150) {
            list.add(new class_1293(class_1294.field_5917, 600));
        }
        if (amount >= 300) {
            list.add(new class_1293(class_1294.field_5903, 600));
        }
        if (amount >= 400 && FabricLoader.getInstance().isModLoaded("dehydration")) {
            //noinspection DataFlowIssue
            list.add(new class_1293(class_7923.field_41174.method_10223(new class_2960("dehydration:thirst_effect")),
                    600, 0));
        }
        if (amount >= 450) {
            list.add(new class_1293(class_1294.field_5904, 600, 1));
        }
        if (amount >= 500) {
            list.add(new class_1293(class_1294.field_5913, 600));
        }
        if (amount >= 600) {
            list.add(new class_1293(class_1294.field_5917, 600, 1));
        }
        if (amount >= 700) {
            list.add(new class_1293(class_1294.field_5913, 600, 1));
        }
        int lethalCaffeineDose = level.method_8450().method_8356(PDGameRules.LETHAL_CAFFEINE_DOSE);
        boolean overdose = level.method_8450().method_8355(PDGameRules.DO_CAFFEINE_OVERDOSE);
        if (overdose && amount >= lethalCaffeineDose) {
            list.add(new class_1293(PDMobEffects.CAFFEINE_OVERDOSE, 20 * 60));
        }
        return list;
    }

    @Override
    public void appendTooltip(List<class_2561> tooltip, float caffeine, class_1799 stack) {
        if (caffeine > 0) tooltip.add(class_2561.method_43469("tooltip.pdapi.caffeine_content", caffeine).method_27692(class_124.field_1075));
    }

    public static void init() {
        class_2378.method_10230(Chemicals.REGISTRY, PDAPI.asId("caffeine"), INSTANCE);
    }

    @Override
    public String formatAmount(float amount) {
        return amount + "mg";
    }
}
