package ml.pluto7073.pdapi.datagen.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@class_6328
public abstract class DrinkAdditionProvider implements class_2405 {

    private final class_7784.class_7489 additionPathProvider;

    public DrinkAdditionProvider(FabricDataOutput out) {
        this.additionPathProvider = out.method_45973(class_7784.class_7490.field_39367, "drink_additions");
    }

    public abstract void buildAdditions(BiConsumer<class_2960, DrinkAddition> consumer);

    @SuppressWarnings("UnstableApiUsage")
    @Override
    public CompletableFuture<?> method_10319(class_7403 output) {
        Set<class_2960> generatedAdditions = Sets.newHashSet();
        List<CompletableFuture<?>> list = new ArrayList<>();

        buildAdditions((id, addition) -> {
            if (!generatedAdditions.add(id)) {
                throw new IllegalStateException("Duplicate Addition " + id);
            }

            JsonElement json = DrinkAddition.CODEC.encodeStart(JsonOps.INSTANCE, addition).getOrThrow(false, s -> {});
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(addition);
            ConditionJsonProvider.write((JsonObject) json, conditions);

            list.add(class_2405.method_10320(output, json, additionPathProvider.method_44107(id)));
        });
        return CompletableFuture.allOf(list.toArray(CompletableFuture[]::new));
    }

    @Override
    public String method_10321() {
        return "Drink Additions";
    }

    protected static DrinkAddition.Builder builder() {
        return new DrinkAddition.Builder();
    }

    @SuppressWarnings("UnstableApiUsage")
    protected BiConsumer<class_2960, DrinkAddition> withConditions(BiConsumer<class_2960, DrinkAddition> output, ConditionJsonProvider... conditions) {
        return (id, drink) -> {
            FabricDataGenHelper.addConditions(drink, conditions);
            output.accept(id, drink);
        };
    }

}
