/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.chemicals.CaffeineHandler;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.recipes.DrinkWorkstationRecipe;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

public final class DrinkUtil {
    private static final HashMap<String, Converter<class_2520>> OLD_CONVERSION_REGISTRY = new HashMap();

    public static class_2960 getAsId(class_2960 file, String dir) {
        return file.method_45134(s -> s.replace(dir + "/", "").replace(".json", ""));
    }

    public static <T> Comparator<T> alphabetizer(Function<T, String> toString) {
        return (o1, o2) -> {
            String first = (String)toString.apply(o1);
            String second = (String)toString.apply(o2);
            int length = Math.min(first.length(), second.length());
            for (int i = 0; i < length; ++i) {
                char c2;
                char c1 = first.charAt(i);
                if (c1 == (c2 = second.charAt(i))) continue;
                return Character.compare(c1, c2);
            }
            return Integer.compare(first.length(), second.length());
        };
    }

    public static int averageColors(Collection<Integer> colors) {
        if (colors.isEmpty()) {
            return 0xFFFFFF;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        for (int color : colors) {
            r += color >> 16 & 0xFF;
            g += color >> 8 & 0xFF;
            b += color & 0xFF;
        }
        return (r /= colors.size()) << 16 | (g /= colors.size()) << 8 | (b /= colors.size());
    }

    public static int getColorForDrinkWithDefault(class_1799 drink, int normal) {
        DrinkAddition[] additions = DrinkUtil.getAdditionsFromStack(drink);
        List colors = Arrays.stream(additions).filter(DrinkAddition::changesColor).map(DrinkAddition::getColor).collect(Collectors.toCollection(ArrayList::new));
        colors.add(0, normal);
        return DrinkUtil.averageColors(colors);
    }

    public static void convertStackFromPlutosCoffee(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("Coffee")) {
            return;
        }
        Stack<String> currentPath = new Stack<String>();
        currentPath.push("Coffee");
        class_2487 oldCoffeeData = nbt.method_10562("Coffee");
        DrinkUtil.handleCompound(currentPath, oldCoffeeData);
        nbt.method_10566("DrinkData", (class_2520)oldCoffeeData);
        nbt.method_10551("Coffee");
    }

    public static <T> List<T> condense(List<T> base) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : base) {
            if (list.isEmpty()) {
                list.add(t);
                continue;
            }
            if (t.equals(list.get(list.size() - 1))) continue;
            list.add(t);
        }
        return list;
    }

    public static <K, V> Map<K, V> or(Map<K, V> first, Map<K, V> second, BiFunction<V, V, V> combiner) {
        HashMap result = new HashMap();
        first.forEach((k, v) -> {
            if (second.containsKey(k)) {
                result.put(k, combiner.apply(v, second.get(k)));
            } else {
                result.put(k, v);
            }
        });
        second.forEach((k, v) -> {
            if (!result.containsKey(k)) {
                result.put(k, v);
            }
        });
        return ImmutableMap.copyOf(result);
    }

    public static <T> boolean sameItems(T[] array1, T[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        List<T> list1 = List.of(array1);
        ArrayList list2 = Lists.newArrayList((Object[])array2);
        for (T t1 : list1) {
            if (!list2.contains(t1)) {
                return false;
            }
            list2.remove(t1);
        }
        return list2.isEmpty();
    }

    private static void handleCompound(Stack<String> currentPath, class_2487 compound) {
        for (String key : compound.method_10541()) {
            class_2520 element = compound.method_10580(key);
            if (element == null) continue;
            currentPath.push(key);
            String current = DrinkUtil.convertPathStackToString(currentPath);
            if (OLD_CONVERSION_REGISTRY.containsKey(current)) {
                element = OLD_CONVERSION_REGISTRY.get(current).convert(element);
                compound.method_10566(key, element);
                continue;
            }
            if (element.method_10711() == 10) {
                DrinkUtil.handleCompound(currentPath, (class_2487)element);
            }
            currentPath.pop();
        }
    }

    public static class_1263 copyContainerContents(class_1263 source) {
        class_1277 container = new class_1277(source.method_5439());
        for (int i = 0; i < source.method_5439(); ++i) {
            container.method_5447(i, source.method_5438(i).method_7972());
        }
        return container;
    }

    public static DrinkAddition[] getAdditionsFromStack(class_1799 stack) {
        DrinkUtil.convertStackFromPlutosCoffee(stack);
        class_2487 drinkData = stack.method_7911("DrinkData");
        class_2499 additions = drinkData.method_10554("Additions", 8);
        ArrayList<DrinkAddition> additionsList = new ArrayList<DrinkAddition>();
        for (int i = 0; i < additions.size(); ++i) {
            String id = additions.method_10608(i);
            class_2960 identifier = new class_2960(id);
            additionsList.add(DrinkAdditionManager.get(identifier));
        }
        return additionsList.toArray(new DrinkAddition[0]);
    }

    public static void registerOldToNewConverter(String nbtPath, Converter<class_2520> converter) {
        OLD_CONVERSION_REGISTRY.put(nbtPath, converter);
    }

    private static String convertPathStackToString(Stack<String> stack) {
        if (stack.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder((String)stack.get(0));
        for (int i = 1; i < stack.size(); ++i) {
            builder.append("/").append((String)stack.get(i));
        }
        return builder.toString();
    }

    public static class_2520 stringAsNbt(String s) {
        class_2487 compound = new class_2487();
        compound.method_10582("string", s);
        return compound.method_10580("string");
    }

    public static float getPlayerCaffeine(class_1657 player) {
        return CaffeineHandler.INSTANCE.get(player);
    }

    public static SpecialtyDrink getSpecialDrink(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        String id = nbt.method_10558("Drink");
        SpecialtyDrink drink = SpecialtyDrinkManager.get(new class_2960(id));
        if (drink == null) {
            throw new IllegalArgumentException("Drink " + id + " does not exist");
        }
        return drink;
    }

    public static class_1799 setSpecialDrink(class_1799 stack, SpecialtyDrink drink) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10566("Drink", (class_2520)class_2519.method_23256((String)drink.id().toString()));
        stack.method_7980(nbt);
        return stack;
    }

    public static int getDrinkColor(class_1799 stack) {
        if (!stack.method_31574(PDItems.SPECIALTY_DRINK)) {
            return -1;
        }
        try {
            SpecialtyDrink drink = DrinkUtil.getSpecialDrink(stack);
            return drink.color();
        }
        catch (IllegalArgumentException e) {
            return 16324805;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1856 additionToIngredient(class_2960 additionId) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            PDAPI.LOGGER.warn("Ingredient list for \"{}\" could not be determined cause you are not in a world", (Object)additionId);
            return class_1856.field_9017;
        }
        List<DrinkWorkstationRecipe> recipes = level.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE).stream().filter(r -> r.getResultId().equals((Object)additionId)).toList();
        if (recipes.isEmpty()) {
            return class_1856.field_9017;
        }
        ArrayList matchingStacks = new ArrayList();
        recipes.forEach(r -> matchingStacks.addAll(Arrays.asList(r.getAddition().method_8105())));
        if (matchingStacks.isEmpty()) {
            return class_1856.field_9017;
        }
        return class_1856.method_26964(matchingStacks.stream());
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1856 getValidBasesForAddition(class_2960 additionId) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            PDAPI.LOGGER.warn("Valid bases for \"{}\" can only be retrieved when a level is loaded", (Object)additionId);
            return class_1856.field_9017;
        }
        List<DrinkWorkstationRecipe> recipes = level.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE).stream().filter(r -> r.getResultId().equals((Object)additionId)).toList();
        if (recipes.isEmpty()) {
            return class_1856.field_9017;
        }
        ArrayList matchingStacks = new ArrayList();
        recipes.forEach(r -> matchingStacks.addAll(Arrays.asList(r.getBase().method_8105())));
        if (matchingStacks.isEmpty()) {
            return class_1856.field_9017;
        }
        return class_1856.method_26964(matchingStacks.stream());
    }

    public static interface Converter<T extends class_2520> {
        public T convert(T var1);
    }
}

