package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ApplyEffectRadiusAction implements OnDrinkAction {

    private static final class_238 ONE_BLOCK = class_2248.method_9541(0, 0, 0, 16, 16, 16).method_1107();

    private final int radius;
    private final boolean includeDrinker;
    private final class_1291 effect;
    private final int duration;
    private final int amplifier;

    public ApplyEffectRadiusAction(int radius, boolean includeDrinker, class_1291 effect, int duration, int amplifier) {
        this.radius = radius;
        this.includeDrinker = includeDrinker;
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        List<class_1309> list =
                level.method_8333(user, ONE_BLOCK.method_1014(radius), entity -> entity instanceof class_1309)
                .stream().map(e -> (class_1309) e).toList();

        for (class_1309 e : list) {
            e.method_6092(new class_1293(effect, duration, amplifier));
        }

        if (includeDrinker) user.method_6092(new class_1293(effect, duration, amplifier));
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.APPLY_EFFECT_RADIUS;
    }

    public static class Serializer implements OnDrinkSerializer<ApplyEffectRadiusAction> {

        @Override
        public ApplyEffectRadiusAction fromJson(JsonObject json) {
            class_2960 effectId = new class_2960(class_3518.method_15265(json, "effect"));
            class_1291 effect = class_7923.field_41174.method_10223(effectId);
            if (effect == null) {
                throw new IllegalArgumentException("Effect ID must point to a Mob Effect that actually exists");
            }
            int duration = class_3518.method_15260(json, "duration");
            int amplifier = class_3518.method_15260(json, "amplifier");
            int radius = class_3518.method_15260(json, "radius");
            boolean includeDrinker = class_3518.method_15270(json, "includeDrinker");
            return new ApplyEffectRadiusAction(radius, includeDrinker, effect, duration, amplifier);
        }

        @Override
        public void toJson(JsonObject json, ApplyEffectRadiusAction action) {
            json.addProperty("radius", action.radius);
            json.addProperty("includeDrinker", action.includeDrinker);
            class_2960 id = class_7923.field_41174.method_29113(action.effect)
                    .orElseThrow(IllegalStateException::new).method_29177();
            json.addProperty("effect", id.toString());
            json.addProperty("duration", action.duration);
            json.addProperty("amplifier", action.amplifier);
        }

        @Override
        public ApplyEffectRadiusAction fromNetwork(class_2540 buf) {
            class_1291 effect = class_7923.field_41174.method_29107(buf.method_44112(class_7924.field_41208));
            int duration = buf.readInt();
            int amplifier = buf.readInt();
            boolean includeDrinker = buf.readBoolean();
            int radius = buf.readInt();
            return new ApplyEffectRadiusAction(radius, includeDrinker, effect, duration, amplifier);
        }

        @Override
        public void toNetwork(class_2540 buf, ApplyEffectRadiusAction action) {
            buf.method_44116(class_7923.field_41174.method_29113(action.effect)
                    .orElseThrow(IllegalStateException::new));
            buf.method_53002(action.duration);
            buf.method_53002(action.amplifier);
            buf.method_52964(action.includeDrinker);
            buf.method_53002(action.radius);
        }
    }

}
