package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public class ClearHarmfulEffectsAction implements OnDrinkAction {

    private final int limit;

    public ClearHarmfulEffectsAction(int limit) {
        this.limit = limit;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        int limit = this.limit;

        if (limit == -1) limit = user.method_6026().size();
        for (class_1293 effect : user.method_6026()) {
            if (effect.method_5579().method_5573()) continue;
            limit--;
            user.method_6016(effect.method_5579());
        }
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.CLEAR_HARMFUL_EFFECTS;
    }

    public static class Serializer implements OnDrinkSerializer<ClearHarmfulEffectsAction> {

        @Override
        public ClearHarmfulEffectsAction fromJson(JsonObject json) {
            int limit = -1;
            if (json.has("limit")) {
                limit = class_3518.method_15260(json, "limit");
            }
            return new ClearHarmfulEffectsAction(limit);
        }

        @Override
        public void toJson(JsonObject json, ClearHarmfulEffectsAction action) {
            if (action.limit == -1) return;
            json.addProperty("limit", action.limit);
        }

        @Override
        public ClearHarmfulEffectsAction fromNetwork(class_2540 buf) {
            return new ClearHarmfulEffectsAction(buf.readInt());
        }

        @Override
        public void toNetwork(class_2540 buf, ClearHarmfulEffectsAction action) {
            buf.method_53002(action.limit);
        }

    }

}
