package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public class RestoreHungerAction implements OnDrinkAction {

    private final int food, saturation;

    public RestoreHungerAction(int food, int saturation) {
        this.food = food;
        this.saturation = saturation;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        if (!(user instanceof class_1657 player)) return;
        player.method_7344().method_7585(food, saturation);
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.RESTORE_HUNGER;
    }

    public static class Serializer implements OnDrinkSerializer<RestoreHungerAction> {

        @Override
        public RestoreHungerAction fromJson(JsonObject json) {
            int food = class_3518.method_15260(json, "food");
            int saturation = class_3518.method_15260(json, "saturation");
            return new RestoreHungerAction(food, saturation);
        }

        @Override
        public void toJson(JsonObject json, RestoreHungerAction action) {
            json.addProperty("food", action.food);
            json.addProperty("saturation", action.saturation);
        }

        @Override
        public RestoreHungerAction fromNetwork(class_2540 buf) {
            int food = buf.readInt();
            int saturation = buf.readInt();
            return new RestoreHungerAction(food, saturation);
        }

        @Override
        public void toNetwork(class_2540 buf, RestoreHungerAction action) {
            buf.method_53002(action.food);
            buf.method_53002(action.saturation);
        }

    }

}
