package ml.pluto7073.pdapi.networking.packet.clientbound;

import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkSerializer;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.Map;

public record ClientboundSyncSpecialtyDrinkRegistryPacket(Map<class_2960, SpecialtyDrink> registry)
        implements FabricPacket {

    public static final PacketType<ClientboundSyncSpecialtyDrinkRegistryPacket> TYPE = PacketType.create(
            PDAPI.asId("clientbound/sync_specialty_drink_registry"),
            ClientboundSyncSpecialtyDrinkRegistryPacket::read
    );

    private static ClientboundSyncSpecialtyDrinkRegistryPacket read(class_2540 buf) {
        return new ClientboundSyncSpecialtyDrinkRegistryPacket(buf.method_34067(
                class_2540::method_10810,
                (b) -> {
                    class_2960 type = b.method_10810();
                    SpecialtyDrinkSerializer serializer = PDRegistries.SPECIALTY_DRINK_SERIALIZER.method_17966(type).orElseThrow(IllegalStateException::new);
                    return serializer.fromNetwork(b);
                }
        ));
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_34063(registry, class_2540::method_10812, (b, d) -> {
            b.method_10812(d.type());
            d.serializer().toNetwork(d, b);
        });
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }
}
