/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.addition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DrinkAddition {
    private final OnDrinkAction[] actions;
    private final boolean changesColor;
    private final int color;
    private final Map<String, Integer> chemicals;
    private final int maxAmount;
    private final int currentWeight;
    private final String name;

    protected DrinkAddition(OnDrinkAction[] actions, boolean changesColor, int color, Map<String, Integer> chemicals, int maxAmount, @Nullable String name) {
        this(actions, changesColor, color, chemicals, maxAmount, name, 0);
    }

    protected DrinkAddition(OnDrinkAction[] actions, boolean changesColor, int color, Map<String, Integer> chemicals, int maxAmount, @Nullable String name, int currentWeight) {
        this.actions = actions;
        this.changesColor = changesColor;
        this.color = color;
        this.chemicals = chemicals;
        this.maxAmount = maxAmount;
        this.currentWeight = currentWeight;
        this.name = name;
    }

    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        for (OnDrinkAction action : this.actions) {
            action.onDrink(stack, level, user);
        }
    }

    public boolean changesColor() {
        return this.changesColor;
    }

    public int getColor() {
        return this.color;
    }

    public Map<String, Integer> getChemicals() {
        return this.chemicals;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public int getCurrentWeight() {
        return this.currentWeight;
    }

    public void toNetwork(class_2540 buf) {
        NetworkingUtils.writeDrinkActionsList(buf, this.actions);
        buf.method_52964(this.changesColor);
        buf.method_53002(this.color);
        buf.method_34063(this.chemicals, class_2540::method_10814, class_2540::method_53002);
        buf.method_53002(this.maxAmount);
        buf.method_53002(this.currentWeight);
        buf.method_10814(Objects.requireNonNullElse(this.name, ""));
    }

    public static DrinkAddition fromNetwork(class_2540 buf) {
        List<OnDrinkAction> actions = NetworkingUtils.readDrinkActionsList(buf);
        boolean changesColor = buf.readBoolean();
        int color = buf.readInt();
        Map chemicals = buf.method_34067(class_2540::method_19772, class_2540::readInt);
        int maxAmount = buf.readInt();
        int currentWeight = buf.readInt();
        String name = buf.method_19772();
        if (name.isEmpty()) {
            name = null;
        }
        return new DrinkAddition((OnDrinkAction[])actions.toArray(OnDrinkAction[]::new), changesColor, color, chemicals, maxAmount, name, currentWeight);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.changesColor) {
            json.addProperty("changesColor", Boolean.valueOf(true));
            json.addProperty("color", (Number)this.color);
        }
        if (this.maxAmount > 0) {
            json.addProperty("maxAmount", (Number)this.maxAmount);
        }
        this.chemicals.forEach((id, amount) -> {
            if (amount > 0) {
                json.addProperty(id, (Number)amount);
            }
        });
        if (this.currentWeight != 0) {
            json.addProperty("weight", (Number)this.currentWeight);
        }
        if (this.name != null) {
            json.addProperty("name", this.name);
        }
        JsonArray actions = new JsonArray();
        for (OnDrinkAction action : this.actions) {
            JsonObject a = new JsonObject();
            OnDrinkSerializer<?> serializer = action.serializer();
            class_2960 id2 = PDRegistries.ON_DRINK_SERIALIZER.method_10221(serializer);
            if (id2 == null) {
                PDAPI.LOGGER.error("Couldn't serialize OnDrink Action");
                continue;
            }
            a.addProperty("type", id2.toString());
            serializer.toJson(a, action);
            actions.add((JsonElement)a);
        }
        json.add("onDrinkActions", (JsonElement)actions);
        return json;
    }

    public String getTranslationKey() {
        if (this.name != null) {
            return this.name;
        }
        try {
            class_2960 id = DrinkAdditionManager.getId(this);
            return id.method_42093("drink_addition");
        }
        catch (IllegalArgumentException e) {
            PDAPI.LOGGER.error("Couldn't get translation key for a drink addition", (Throwable)e);
            return "drink_addition.pdapi.empty";
        }
    }

    public static class Builder {
        private final List<OnDrinkAction> actions = new ArrayList<OnDrinkAction>();
        private boolean changesColor = false;
        private int color = 0;
        private final HashMap<String, Integer> chemicals = new HashMap();
        private int maxAmount;
        private int weight;
        private String name;

        public Builder() {
            ConsumableChemicalRegistry.forEach(handler -> this.chemical(handler.getName(), 0));
            this.maxAmount = 0;
            this.weight = 0;
            this.name = null;
        }

        public Builder addAction(OnDrinkAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder changesColor(boolean changesColor) {
            this.changesColor = changesColor;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder chemical(String name, int amount) {
            this.chemicals.put(name, amount);
            return this;
        }

        public Builder maxAmount(int amount) {
            this.maxAmount = amount;
            return this;
        }

        public Builder setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public DrinkAddition build() {
            return new DrinkAddition((OnDrinkAction[])this.actions.toArray(OnDrinkAction[]::new), this.changesColor, this.color, this.chemicals, this.maxAmount, this.name, this.weight);
        }
    }
}

