/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.networking;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class NetworkingUtils {
    private static final int INT_TYPE = 0;
    private static final int FLOAT_TYPE = 1;
    private static final int BOOLEAN_TYPE = 2;
    private static final int STRING_TYPE = 3;
    private static final int ARRAY_BEGIN_TYPE = 4;
    private static final int ARRAY_END_TYPE = 5;
    private static final int OBJECT_BEGIN_TYPE = 6;
    private static final int OBJECT_END_TYPE = 7;
    private static final int KEY_TYPE = 8;

    public static JsonObject readJsonObject(class_2540 buffer) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(6);
        int i = buffer.readInt();
        if (i != 6) {
            throw new IllegalStateException("Expected object initializer as first signal");
        }
        return NetworkingUtils.readJsonObject(buffer, stack);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static JsonObject readJsonObject(class_2540 buffer, Stack<Integer> objectLevels) {
        JsonObject object = new JsonObject();
        String currentKey = "";
        block11: while (true) {
            int signal = buffer.readInt();
            switch (signal) {
                case 0: {
                    object.add(currentKey, (JsonElement)new JsonPrimitive((Number)buffer.readInt()));
                    break;
                }
                case 1: {
                    object.add(currentKey, (JsonElement)new JsonPrimitive((Number)Float.valueOf(buffer.readFloat())));
                    break;
                }
                case 2: {
                    object.add(currentKey, (JsonElement)new JsonPrimitive(Boolean.valueOf(buffer.readBoolean())));
                    break;
                }
                case 3: {
                    object.add(currentKey, (JsonElement)new JsonPrimitive(buffer.method_19772()));
                    break;
                }
                case 4: {
                    objectLevels.push(4);
                    object.add(currentKey, (JsonElement)NetworkingUtils.readJsonArray(buffer, objectLevels));
                    objectLevels.pop();
                    break;
                }
                case 5: {
                    throw new IllegalStateException("Unexpected array ending");
                }
                case 6: {
                    objectLevels.push(6);
                    object.add(currentKey, (JsonElement)NetworkingUtils.readJsonObject(buffer, objectLevels));
                    objectLevels.pop();
                    break;
                }
                case 7: {
                    if (objectLevels.isEmpty()) {
                        throw new IllegalStateException("Unexpected object ending");
                    }
                    if (objectLevels.peek() == 6) break block11;
                    throw new IllegalStateException("Unexpected object ending");
                }
                case 8: {
                    currentKey = buffer.method_19772();
                }
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static JsonArray readJsonArray(class_2540 buffer, Stack<Integer> objectLevels) {
        JsonArray array = new JsonArray();
        block11: while (true) {
            int signal = buffer.readInt();
            switch (signal) {
                case 0: {
                    array.add((Number)buffer.readInt());
                    break;
                }
                case 1: {
                    array.add((Number)Float.valueOf(buffer.readFloat()));
                    break;
                }
                case 2: {
                    array.add(Boolean.valueOf(buffer.readBoolean()));
                    break;
                }
                case 3: {
                    array.add(buffer.method_19772());
                    break;
                }
                case 4: {
                    objectLevels.push(4);
                    array.add((JsonElement)NetworkingUtils.readJsonArray(buffer, objectLevels));
                    objectLevels.pop();
                    break;
                }
                case 5: {
                    if (objectLevels.isEmpty()) {
                        throw new IllegalStateException("Unexpected Array Ending");
                    }
                    if (objectLevels.peek() == 4) break block11;
                    throw new IllegalStateException("Unexpected Array Ending");
                }
                case 6: {
                    objectLevels.push(6);
                    array.add((JsonElement)NetworkingUtils.readJsonObject(buffer, objectLevels));
                    objectLevels.pop();
                    break;
                }
                case 7: {
                    throw new IllegalStateException("Unexpected Object Ending");
                }
                case 8: {
                    throw new IllegalStateException("Unexpected Key Type");
                }
            }
        }
        return array;
    }

    public static void writeJsonObjectStart(class_2540 buf, JsonObject object) {
        buf.method_53002(6);
        NetworkingUtils.writeJsonObject(buf, object);
    }

    private static void writeJsonObject(class_2540 buf, JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            buf.method_53002(8);
            buf.method_10814((String)entry.getKey());
            JsonElement value = (JsonElement)entry.getValue();
            NetworkingUtils.writeValue(value, buf);
        }
        buf.method_53002(7);
    }

    private static void writeJsonArray(class_2540 buf, JsonArray array) {
        for (JsonElement value : array) {
            NetworkingUtils.writeValue(value, buf);
        }
        buf.method_53002(5);
    }

    private static void writeValue(JsonElement value, class_2540 buf) {
        if (value.isJsonArray()) {
            buf.method_53002(4);
            NetworkingUtils.writeJsonArray(buf, value.getAsJsonArray());
        } else if (value.isJsonObject()) {
            buf.method_53002(6);
            NetworkingUtils.writeJsonObject(buf, value.getAsJsonObject());
        } else if (value.isJsonPrimitive()) {
            JsonPrimitive primVal = value.getAsJsonPrimitive();
            if (primVal.isBoolean()) {
                buf.method_53002(2);
                buf.method_52964(primVal.getAsBoolean());
            } else if (primVal.isNumber()) {
                if ((float)primVal.getAsNumber().intValue() == primVal.getAsNumber().floatValue()) {
                    buf.method_53002(0);
                    buf.method_53002(primVal.getAsInt());
                } else {
                    buf.method_53002(1);
                    buf.method_52941(primVal.getAsFloat());
                }
            } else if (primVal.isString()) {
                buf.method_53002(3);
                buf.method_10814(primVal.getAsString());
            }
        }
    }

    public static <T> JsonObject[] convertToJson(T[] array, Function<T, JsonObject> converter) {
        JsonObject[] result = new JsonObject[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = converter.apply(array[i]);
        }
        return result;
    }

    public static <T> void arrayToNetwork(class_2540 buf, T[] array, class_2540.class_7462<T> itemWriter) {
        HashMap<Integer, T> intMap = new HashMap<Integer, T>();
        for (int i = 0; i < array.length; ++i) {
            intMap.put(i, array[i]);
        }
        buf.method_34063(intMap, class_2540::method_53002, itemWriter);
    }

    public static <T> List<T> listFromNetwork(class_2540 buf, class_2540.class_7461<T> itemReader) {
        Map intMap = buf.method_34067(class_2540::readInt, itemReader);
        ArrayList list = new ArrayList();
        for (int i = 0; i < intMap.size(); ++i) {
            list.add(intMap.get(i));
        }
        return list;
    }

    public static List<OnDrinkAction> readDrinkActionsList(class_2540 buf) {
        return NetworkingUtils.listFromNetwork(buf, b -> {
            class_2960 id = b.method_10810();
            OnDrinkSerializer serializer = (OnDrinkSerializer)PDRegistries.ON_DRINK_SERIALIZER.method_10223(id);
            if (serializer == null) {
                throw new IllegalStateException();
            }
            return serializer.fromNetwork((class_2540)b);
        });
    }

    public static void writeDrinkActionsList(class_2540 buf, OnDrinkAction[] actions) {
        NetworkingUtils.arrayToNetwork(buf, actions, (b, action) -> {
            OnDrinkSerializer<?> serializer = action.serializer();
            class_2960 id = PDRegistries.ON_DRINK_SERIALIZER.method_10221(serializer);
            b.method_10812(id);
            serializer.toNetwork((class_2540)b, action);
        });
    }
}

