/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.InProgressItemRegistry;
import ml.pluto7073.pdapi.tag.PDTags;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6328;

@class_6328
public class DrinkWorkstationRecipe
implements class_1860<class_1263> {
    final class_1856 base;
    final class_1856 addition;
    final class_2960 result;

    public DrinkWorkstationRecipe(class_1856 base, class_1856 addition, class_2960 result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return this.base.method_8093(inventory.method_5438(0)) && this.addition.method_8093(inventory.method_5438(1));
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return this.craft(inventory);
    }

    public class_1799 craft(class_1263 inventory) {
        class_1799 stack = inventory.method_5438(0).method_7972();
        class_2499 resAdds = stack.method_7911("DrinkData").method_10554("Additions", 8);
        resAdds.add((Object)DrinkUtil.stringAsNbt(this.result.toString()));
        stack.method_7911("DrinkData").method_10566("Additions", (class_2520)resAdds);
        if (stack.method_31573(PDTags.HAS_IN_PROGRESS_ITEM)) {
            class_2487 tag = stack.method_7948();
            stack = new class_1799((class_1935)InProgressItemRegistry.getInProgress(stack.method_7909()));
            stack.method_7980(tag);
        }
        return stack;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        class_1799 stack = this.base.method_8105()[0].method_7972();
        if (stack.method_31573(PDTags.HAS_IN_PROGRESS_ITEM)) {
            stack = this.base.method_8105().length > 1 ? this.base.method_8105()[1].method_7972() : new class_1799((class_1935)InProgressItemRegistry.getInProgress(stack.method_7909()));
        }
        class_2499 adds = new class_2499();
        adds.add((Object)DrinkUtil.stringAsNbt(this.result.toString()));
        stack.method_7911("DrinkData").method_10566("Additions", (class_2520)adds);
        return stack;
    }

    public class_1856 getBase() {
        return this.base;
    }

    public class_1856 getAddition() {
        return this.addition;
    }

    public class_2960 getResult() {
        return this.result;
    }

    public boolean testAddition(class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public boolean testBase(class_1799 stack) {
        return this.base.method_8093(stack);
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)PDBlocks.DRINK_WORKSTATION);
    }

    public class_1865<?> method_8119() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE;
    }

    public boolean method_31584() {
        return Stream.of(this.base, this.addition).anyMatch(ingredient -> ingredient.method_8105().length == 0);
    }

    @class_6328
    public static class Serializer
    implements class_1865<DrinkWorkstationRecipe> {
        private static final Codec<DrinkWorkstationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1856.field_46095.fieldOf("base").forGetter(recipe -> recipe.base), (App)class_1856.field_46095.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)class_2960.field_25139.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, DrinkWorkstationRecipe::new));

        public Codec<DrinkWorkstationRecipe> method_53736() {
            return CODEC;
        }

        public DrinkWorkstationRecipe fromNetwork(class_2540 buf) {
            class_1856 ingredient = class_1856.method_8086((class_2540)buf);
            class_1856 ingredient2 = class_1856.method_8086((class_2540)buf);
            class_2960 result = buf.method_10810();
            return new DrinkWorkstationRecipe(ingredient, ingredient2, result);
        }

        public void toNetwork(class_2540 buf, DrinkWorkstationRecipe recipe) {
            recipe.base.method_8088(buf);
            recipe.addition.method_8088(buf);
            buf.method_10812(recipe.result);
        }
    }
}

