package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ApplyStatusEffectAction implements OnDrinkAction {

    private final class_1291 effect;
    private final int duration, amplifier;

    public ApplyStatusEffectAction(class_1291 effect, int duration, int amplifier) {
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        user.method_6092(new class_1293(effect, duration, amplifier));
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.APPLY_STATUS_EFFECT;
    }

    public static class Serializer implements OnDrinkSerializer<ApplyStatusEffectAction> {

        public static final Codec<ApplyStatusEffectAction> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(class_7923.field_41174.method_39673().fieldOf("effect").forGetter(action -> action.effect),
                        Codec.INT.fieldOf("duration").forGetter(action -> action.duration),
                        Codec.INT.fieldOf("amplifier").forGetter(action -> action.amplifier))
                        .apply(instance, ApplyStatusEffectAction::new));

        @Override
        public Codec<ApplyStatusEffectAction> codec() {
            return CODEC;
        }

        @Override
        public ApplyStatusEffectAction fromNetwork(class_2540 buf) {
            class_2960 id = buf.method_10810();
            class_1291 effect = class_7923.field_41174.method_10223(id);
            if (effect == null) throw new IllegalStateException();
            int duration = buf.readInt();
            int amplifier = buf.readInt();
            return new ApplyStatusEffectAction(effect, duration, amplifier);
        }

        @Override
        public void toNetwork(class_2540 buf, ApplyStatusEffectAction action) {
            class_2960 id = class_7923.field_41174.method_10221(action.effect);
            if (id == null) throw new IllegalStateException();
            buf.method_10812(id);
            buf.method_53002(action.duration);
            buf.method_53002(action.amplifier);
        }
    }

}
