package ml.pluto7073.pdapi.addition.action;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;

public class ClearHarmfulEffectsAction implements OnDrinkAction {

    private final int limit;

    public ClearHarmfulEffectsAction(int limit) {
        this.limit = limit;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        int limit = this.limit;

        if (limit == -1) limit = user.method_6026().size();
        for (class_1293 effect : user.method_6026()) {
            if (effect.method_5579().method_5573()) continue;
            limit--;
            user.method_6016(effect.method_5579());
        }
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return OnDrinkSerializers.CLEAR_HARMFUL_EFFECTS;
    }

    public static class Serializer implements OnDrinkSerializer<ClearHarmfulEffectsAction> {

        public static final Codec<ClearHarmfulEffectsAction> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(Codec.INT.fieldOf("limit").orElse(-1).forGetter(action -> action.limit))
                        .apply(instance, ClearHarmfulEffectsAction::new));

        @Override
        public Codec<ClearHarmfulEffectsAction> codec() {
            return CODEC;
        }

        @Override
        public ClearHarmfulEffectsAction fromNetwork(class_2540 buf) {
            return new ClearHarmfulEffectsAction(buf.readInt());
        }

        @Override
        public void toNetwork(class_2540 buf, ClearHarmfulEffectsAction action) {
            buf.method_53002(action.limit);
        }

    }

}
