package ml.pluto7073.pdapi.datagen.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@class_6328
public abstract class DrinkAdditionProvider implements class_2405 {

    private final class_7784.class_7489 additionPathProvider;

    public DrinkAdditionProvider(FabricDataOutput out) {
        this.additionPathProvider = out.method_45973(class_7784.class_7490.field_39367, "drink_additions");
    }

    public abstract void buildAdditions(BiConsumer<class_2960, DrinkAddition> consumer);

    @Override
    public CompletableFuture<?> method_10319(class_7403 output) {
        Set<class_2960> generatedAdditions = Sets.newHashSet();
        List<CompletableFuture<?>> list = new ArrayList<>();

        buildAdditions((id, addition) -> {
            if (!generatedAdditions.add(id)) {
                throw new IllegalStateException("Duplicate Addition " + id);
            }

            list.add(class_2405.method_53496(output, DrinkAddition.CODEC, addition, additionPathProvider.method_44107(id)));
        });
        return CompletableFuture.allOf(list.toArray(CompletableFuture[]::new));
    }

    @Override
    public String method_10321() {
        return "Drink Additions";
    }

    protected static DrinkAddition.Builder builder() {
        return new DrinkAddition.Builder();
    }

}
