package ml.pluto7073.pdapi.recipes;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.specialty.InProgressItemRegistry;
import ml.pluto7073.pdapi.tag.PDTags;
import java.util.stream.Stream;

@class_6328
public class DrinkWorkstationRecipe implements class_1860<class_1263> {

    final class_1856 base;
    final class_1856 addition;
    final class_2960 result;

    public DrinkWorkstationRecipe(class_1856 base, class_1856 addition, class_2960 result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    @Override
    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return base.method_8093(inventory.method_5438(0)) && addition.method_8093(inventory.method_5438(1));
    }

    @Override
    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return craft(inventory);
    }

    public class_1799 craft(class_1263 inventory) {
        class_1799 stack = inventory.method_5438(0).method_7972();
        class_2499 resAdds = stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY)
                .method_10554(DrinkAdditionManager.ADDITIONS_NBT_KEY, class_2520.field_33258);
        resAdds.add(DrinkUtil.stringAsNbt(result.toString()));
        stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY).method_10566(DrinkAdditionManager.ADDITIONS_NBT_KEY, resAdds);
        if (stack.method_31573(PDTags.HAS_IN_PROGRESS_ITEM)) {
            class_2487 tag = stack.method_7948();
            stack = new class_1799(InProgressItemRegistry.getInProgress(stack.method_7909()));
            stack.method_7980(tag);
        }
        return stack;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public class_1799 method_8110(class_5455 registryManager) {
        class_1799 stack = base.method_8105()[0].method_7972();
        if (stack.method_31573(PDTags.HAS_IN_PROGRESS_ITEM)) {
            if (base.method_8105().length > 1) {
                stack = base.method_8105()[1].method_7972();
            } else stack = new class_1799(InProgressItemRegistry.getInProgress(stack.method_7909()));
        }
        class_2499 adds = new class_2499();
        adds.add(DrinkUtil.stringAsNbt(result.toString()));
        stack.method_7911(AbstractCustomizableDrinkItem.DRINK_DATA_NBT_KEY).method_10566(DrinkAdditionManager.ADDITIONS_NBT_KEY, adds);
        return stack;
    }

    public class_1856 getBase() { return base; }

    public class_1856 getAddition() { return addition; }

    public class_2960 getResult() { return result; }

    public boolean testAddition(class_1799 stack) {
        return addition.method_8093(stack);
    }

    public boolean testBase(class_1799 stack) {
        return base.method_8093(stack);
    }

    public class_1799 method_17447() {
        return new class_1799(PDBlocks.DRINK_WORKSTATION);
    }

    @Override
    public class_1865<?> method_8119() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE;
    }

    public boolean method_31584() {
        return Stream.of(this.base, this.addition).anyMatch((ingredient) -> ingredient.method_8105().length == 0);
    }

    @class_6328
    public static class Serializer implements class_1865<DrinkWorkstationRecipe> {

        private static final Codec<DrinkWorkstationRecipe> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(class_1856.field_46095.fieldOf("base").forGetter(recipe -> recipe.base),
                        class_1856.field_46095.fieldOf("addition").forGetter(recipe -> recipe.addition),
                        class_2960.field_25139.fieldOf("result").forGetter(recipe -> recipe.result))
                .apply(instance, DrinkWorkstationRecipe::new));

        public Serializer() {}

        @Override
        public Codec<DrinkWorkstationRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public DrinkWorkstationRecipe method_8122(class_2540 buf) {
            class_1856 ingredient = class_1856.method_8086(buf);
            class_1856 ingredient2 = class_1856.method_8086(buf);
            class_2960 result = buf.method_10810();
            return new DrinkWorkstationRecipe(ingredient, ingredient2, result);
        }

        @Override
        public void toNetwork(class_2540 buf, DrinkWorkstationRecipe recipe) {
            recipe.base.method_8088(buf);
            recipe.addition.method_8088(buf);
            buf.method_10812(recipe.result);
        }

    }

}
