/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.specialty;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkSerializer;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@class_6328
public class SpecialtyDrink {
    public static final Codec<SpecialtyDrink> CODEC = PDRegistries.SPECIALTY_DRINK_SERIALIZER.method_39673().dispatch(SpecialtyDrink::serializer, SpecialtyDrinkSerializer::codec);
    private final class_1792 base;
    private final class_2960[] steps;
    private final OnDrinkAction[] actions;
    private final int color;
    private final Map<String, Integer> chemicals;
    private final String name;

    public SpecialtyDrink(class_1792 base, List<class_2960> steps, List<OnDrinkAction> actions, int color, Map<String, Integer> chemicals, @Nullable String name) {
        this.base = base;
        this.steps = (class_2960[])steps.toArray(class_2960[]::new);
        this.actions = (OnDrinkAction[])actions.toArray(OnDrinkAction[]::new);
        this.color = color;
        this.chemicals = new HashMap<String, Integer>(chemicals);
        ConsumableChemicalRegistry.fillChemicalMap(this.chemicals);
        this.name = name;
    }

    public String languageKey() {
        return this.id().method_42093("drink");
    }

    public class_2960 id() {
        return SpecialtyDrinkManager.getId(this);
    }

    public class_1792 base() {
        return this.base;
    }

    public class_1799 baseAsStack() {
        return new class_1799((class_1935)this.base);
    }

    public class_2960[] steps() {
        return this.steps;
    }

    public OnDrinkAction[] actions() {
        return this.actions;
    }

    public int color() {
        return this.color;
    }

    public Map<String, Integer> chemicals() {
        return this.chemicals;
    }

    public String name() {
        return this.name == null || this.name.isEmpty() ? this.languageKey() : this.name;
    }

    public class_2960 type() {
        return PDAPI.asId("specialty_drink");
    }

    public SpecialtyDrinkSerializer serializer() {
        return SpecialtyDrinkSerializer.DEFAULT_SERIALIZER;
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799((class_1935)PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getAsOriginalItemWithAdditions(class_1799 source) {
        class_1799 stack = this.baseAsStack();
        class_2487 ogData = source.method_7911("DrinkData");
        class_2487 drinkData = ogData.method_10553();
        class_2499 list = new class_2499();
        for (class_2960 step : this.steps) {
            list.add((Object)class_2519.method_23256((String)step.toString()));
        }
        list.addAll((Collection)ogData.method_10554("Additions", 8));
        drinkData.method_10566("Additions", (class_2520)list);
        stack.method_7948().method_10566("DrinkData", (class_2520)drinkData);
        return stack;
    }

    public boolean matches(class_1263 container) {
        class_1799 currentResult = container.method_5438(0);
        if (!currentResult.method_31574(this.base)) {
            return false;
        }
        class_2499 additions = currentResult.method_7911("DrinkData").method_10554("Additions", 8);
        if (this.steps.length != additions.size()) {
            return false;
        }
        for (int i = 0; i < additions.size(); ++i) {
            String wanted;
            String actual = additions.method_10608(i);
            if (actual.equals(wanted = this.steps[i].toString())) continue;
            return false;
        }
        return true;
    }

    public List<class_1856> stepsToIngredientList() {
        ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
        for (class_2960 addition : this.steps) {
            ingredients.add(DrinkUtil.additionToIngredient(addition));
        }
        return ingredients;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_10812(class_7923.field_41178.method_10221((Object)this.base));
        NetworkingUtils.arrayToNetwork(buf, this.steps, class_2540::method_10812);
        buf.method_34063(this.chemicals, class_2540::method_10814, class_2540::method_53002);
        buf.method_53002(this.color);
        NetworkingUtils.writeDrinkActionsList(buf, this.actions);
        buf.method_10814(this.name);
    }

    public static class BaseSerializer
    implements SpecialtyDrinkSerializer {
        public static final Codec<SpecialtyDrink> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("base").forGetter(drink -> drink.base), (App)Codec.list((Codec)class_2960.field_25139).fieldOf("additions").forGetter(drink -> List.of(drink.steps)), (App)Codec.list(OnDrinkAction.CODEC).fieldOf("onDrinkActions").forGetter(drink -> List.of(drink.actions)), (App)Codec.INT.fieldOf("color").forGetter(drink -> drink.color), (App)Codec.simpleMap((Codec)Codec.STRING, (Codec)Codec.INT, (Keyable)Keyable.forStrings(() -> ConsumableChemicalRegistry.ids().stream())).orElse(new HashMap()).fieldOf("chemicals").forGetter(drink -> drink.chemicals), (App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(drink -> drink.name)).apply((Applicative)instance, SpecialtyDrink::new));

        @Override
        public Codec<SpecialtyDrink> codec() {
            return CODEC;
        }

        @Override
        public SpecialtyDrink fromNetwork(class_2540 buf) {
            class_2960 base = buf.method_10810();
            List<class_2960> steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810);
            HashMap chemicals = Maps.newHashMap((Map)buf.method_34067(class_2540::method_19772, class_2540::readInt));
            int color = buf.readInt();
            List<OnDrinkAction> list = NetworkingUtils.readDrinkActionsList(buf);
            String name = buf.method_19772();
            return new SpecialtyDrink((class_1792)class_7923.field_41178.method_10223(base), steps, list, color, chemicals, name);
        }

        @Override
        public void toNetwork(SpecialtyDrink drink, class_2540 buf) {
            drink.toNetwork(buf);
        }
    }
}

