package ml.pluto7073.pdapi.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public record DrinkAdditions(List<DrinkAddition> additions) implements class_9299 {

    public static final DrinkAdditions EMPTY = new DrinkAdditions(new ArrayList<>());
    public static final Codec<DrinkAdditions> CODEC = DrinkAddition.COMPONENT_CODEC.listOf().xmap(DrinkAdditions::new, DrinkAdditions::additions);
    public static final class_9139<class_9129, DrinkAdditions> STREAM_CODEC =
            class_9139.method_56437(class_9135.method_56896(CODEC), class_9135.method_56896(CODEC));

    public static DrinkAdditions or(DrinkAdditions first, DrinkAdditions second) {
        List<DrinkAddition> additions = Lists.newArrayList(first.additions);
        additions.addAll(second.additions);
        return new DrinkAdditions(additions);
    }

    public static DrinkAdditions of(List<class_2960> additions) {
        return new DrinkAdditions(additions.stream().map(DrinkAdditionManager::get).toList());
    }

    public static DrinkAdditions of(class_2960 addition) {
        return new DrinkAdditions(List.of(DrinkAdditionManager.get(addition)));
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 config) {
        HashMap<class_2960, Integer> additionCounts = new HashMap<>();
        List<class_2960> order = new ArrayList<>();
        for (DrinkAddition addIn : additions) {
            if (addIn == DrinkAdditionManager.EMPTY) continue;
            class_2960 id = DrinkAdditionManager.getId(addIn);
            if (additionCounts.containsKey(id)) {
                int count = additionCounts.get(id);
                additionCounts.put(id, ++count);
            } else {
                additionCounts.put(id, 1);
                order.add(id);
            }
        }
        order.forEach(id -> tooltip.accept(class_2561.method_43469(DrinkAdditionManager.get(id).getTranslationKey(), additionCounts.get(id)).method_27692(class_124.field_1080)));

    }

    public DrinkAdditions withAddition(DrinkAddition addition) {
        return new DrinkAdditions(class_156.method_57108(additions, addition));
    }
}
