package ml.pluto7073.pdapi.networking;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import net.minecraft.class_2540;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import java.util.*;
import java.util.function.Function;

public final class NetworkingUtils {

    public static <T> void arrayToNetwork(class_2540 buf, T[] array, class_9142<? super class_2540, T> itemWriter) {
        HashMap<Integer, T> intMap = new HashMap<>();
        for (int i = 0; i < array.length; i++) {
            intMap.put(i, array[i]);
        }
        buf.method_34063(intMap, class_2540::method_53002, itemWriter);
    }

    public static <T> List<T> listFromNetwork(class_2540 buf, class_9141<? super class_2540, T> itemReader) {
        Map<Integer, T> intMap = buf.method_34067(class_2540::readInt, itemReader);
        List<T> list = new ArrayList<>();
        for (int i = 0; i < intMap.size(); i++) {
            list.add(intMap.get(i));
        }
        return list;
    }

}
