package ml.pluto7073.pdapi.recipes;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.component.DrinkAdditions;
import ml.pluto7073.pdapi.component.PDComponents;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6328;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.specialty.InProgressItemRegistry;
import ml.pluto7073.pdapi.tag.PDTags;
import java.util.stream.Stream;

@class_6328
public class DrinkWorkstationRecipe implements class_1860<class_1263> {

    final class_1856 base;
    final class_1856 addition;
    final class_2960 result;

    public DrinkWorkstationRecipe(class_1856 base, class_1856 addition, class_2960 result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    @Override
    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return base.method_8093(inventory.method_5438(0)) && addition.method_8093(inventory.method_5438(1));
    }

    @Override
    public class_1799 method_8116(class_1263 inventory, class_7225.class_7874 registryManager) {
        return craft(inventory);
    }

    public class_1799 craft(class_1263 inventory) {
        class_1799 stack = inventory.method_5438(0).method_7972();
        if (stack.method_31573(PDTags.HAS_IN_PROGRESS_ITEM)) {
            stack = new class_1799(InProgressItemRegistry.getInProgress(stack.method_7909()));
        }
        DrinkAdditions additions = stack.method_57825(PDComponents.ADDITIONS, DrinkAdditions.EMPTY)
                .withAddition(DrinkAdditionManager.get(result));
        stack.method_57379(PDComponents.ADDITIONS, additions);
        return stack;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        class_1799 stack = base.method_8105()[0].method_7972();
        stack.method_57379(PDComponents.ADDITIONS, DrinkAdditions.of(result));
        return stack;
    }

    public class_1856 getBase() { return base; }

    public class_1856 getAddition() { return addition; }

    public class_2960 getResult() { return result; }

    public boolean testAddition(class_1799 stack) {
        return addition.method_8093(stack);
    }

    public boolean testBase(class_1799 stack) {
        return base.method_8093(stack);
    }

    public class_1799 method_17447() {
        return new class_1799(PDBlocks.DRINK_WORKSTATION);
    }

    @Override
    public class_1865<?> method_8119() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE;
    }

    public boolean method_31584() {
        return Stream.of(this.base, this.addition).anyMatch((ingredient) -> ingredient.method_8105().length == 0);
    }

    @class_6328
    public static class Serializer implements class_1865<DrinkWorkstationRecipe> {

        private static final MapCodec<DrinkWorkstationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance ->
                instance.group(class_1856.field_46095.fieldOf("base").forGetter(DrinkWorkstationRecipe::getBase),
                        class_1856.field_46095.fieldOf("addition").forGetter(DrinkWorkstationRecipe::getAddition),
                        class_2960.field_25139.fieldOf("result").forGetter(DrinkWorkstationRecipe::getResult))
                .apply(instance, DrinkWorkstationRecipe::new));

        public static final class_9139<class_9129, DrinkWorkstationRecipe> STREAM_CODEC =
                class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public Serializer() {}

        @Override
        public MapCodec<DrinkWorkstationRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, DrinkWorkstationRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static DrinkWorkstationRecipe fromNetwork(class_9129 buf) {
            class_1856 ingredient = class_1856.field_48355.decode(buf);
            class_1856 ingredient2 = class_1856.field_48355.decode(buf);
            class_2960 result = class_2960.field_48267.decode(buf);
            return new DrinkWorkstationRecipe(ingredient, ingredient2, result);
        }

        public static void toNetwork(class_9129 buf, DrinkWorkstationRecipe recipe) {
            class_1856.field_48355.encode(buf, recipe.base);
            class_1856.field_48355.encode(buf, recipe.addition);
            class_2960.field_48267.encode(buf, recipe.result);
        }

    }

}
