/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.client.gui;

import java.util.List;
import java.util.Optional;
import ml.pluto7073.pdapi.block.PDBlocks;
import ml.pluto7073.pdapi.client.gui.PDScreens;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.recipes.DrinkWorkstationRecipe;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3914;
import net.minecraft.class_4861;
import net.minecraft.class_6328;
import net.minecraft.class_8047;
import net.minecraft.class_8786;

@class_6328
public class DrinkWorkstationMenu
extends class_4861 {
    private final class_1937 world;
    private class_8786<DrinkWorkstationRecipe> currentRecipe;
    private final List<class_8786<DrinkWorkstationRecipe>> recipes;

    public DrinkWorkstationMenu(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public DrinkWorkstationMenu(int syncId, class_1661 playerInventory, class_3914 context) {
        super(PDScreens.WORKSTATION_MENU_TYPE, syncId, playerInventory, context);
        this.world = playerInventory.field_7546.method_37908();
        this.recipes = this.world.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE);
    }

    protected boolean method_24927(class_1657 player, boolean present) {
        return this.currentRecipe != null && ((DrinkWorkstationRecipe)this.currentRecipe.comp_1933()).method_8115(this.field_22480, this.world);
    }

    protected void method_24923(class_1657 player, class_1799 stack) {
        stack.method_7982(player.method_37908(), player, stack.method_7947());
        this.field_22479.method_7664(player, List.of(this.method_7611(0).method_7677(), this.method_7611(1).method_7677()));
        this.decrementStack(0, player);
        this.decrementStack(1, player);
        this.field_22481.method_17393((world, pos) -> world.method_20290(10000, pos, 0));
    }

    private void decrementStack(int slot, class_1657 player) {
        class_1799 itemStack = this.field_22480.method_5438(slot);
        if (itemStack.method_7947() == 1) {
            if (itemStack.method_7909().method_7857()) {
                itemStack = new class_1799((class_1935)itemStack.method_7909().method_7858(), 1);
            } else {
                itemStack.method_7934(1);
            }
        } else if (itemStack.method_7947() > 1) {
            itemStack.method_7934(1);
            if (itemStack.method_7909().method_7857()) {
                player.method_7270(new class_1799((class_1935)itemStack.method_7909().method_7858(), 1));
            }
        }
        this.field_22480.method_5447(slot, itemStack);
    }

    protected boolean method_24925(class_2680 state) {
        return state.method_27852(PDBlocks.DRINK_WORKSTATION);
    }

    public void method_24928() {
        List list;
        class_1263 testInput = DrinkUtil.copyContainerContents(this.field_22480);
        if (this.field_22480.method_5438(0).method_31574(PDItems.SPECIALTY_DRINK)) {
            testInput.method_5447(0, DrinkUtil.getSpecialDrink(this.field_22480.method_5438(0)).getAsOriginalItemWithAdditions(this.field_22480.method_5438(0)));
        }
        if ((list = this.world.method_8433().method_17877(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE, testInput, this.world)).isEmpty()) {
            this.field_22479.method_5447(0, class_1799.field_8037);
        } else {
            List<SpecialtyDrink> matchingDrinks;
            this.currentRecipe = (class_8786)list.get(0);
            class_1799 stack = ((DrinkWorkstationRecipe)this.currentRecipe.comp_1933()).craft(this.field_22480);
            this.field_22479.method_7662(this.currentRecipe);
            this.field_22479.method_5447(0, stack);
            class_1263 testResults = DrinkUtil.copyContainerContents((class_1263)this.field_22479);
            if (this.field_22479.method_5438(0).method_31574(PDItems.SPECIALTY_DRINK)) {
                testResults.method_5447(0, DrinkUtil.getSpecialDrink(this.field_22479.method_5438(0)).getAsOriginalItemWithAdditions(this.field_22479.method_5438(0)));
            }
            if ((matchingDrinks = SpecialtyDrinkManager.values().stream().filter(drink -> drink.matches(testResults)).toList()).isEmpty()) {
                return;
            }
            SpecialtyDrink drink2 = matchingDrinks.get(0);
            stack = drink2.getAsItem();
            this.field_22479.method_5447(0, stack);
        }
    }

    protected class_8047 method_48352() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> this.recipes.stream().anyMatch(recipe -> ((DrinkWorkstationRecipe)recipe.comp_1933()).testBase((class_1799)stack))).method_48374(1, 76, 47, stack -> this.recipes.stream().anyMatch(recipe -> ((DrinkWorkstationRecipe)recipe.comp_1933()).testAddition((class_1799)stack))).method_48373(2, 134, 47).method_48372();
    }

    private static Optional<Integer> getQuickMoveSlot(DrinkWorkstationRecipe recipe, class_1799 stack) {
        if (recipe.testBase(stack)) {
            return Optional.of(0);
        }
        return recipe.testAddition(stack) ? Optional.of(1) : Optional.empty();
    }

    protected boolean method_48356(class_1799 stack) {
        return this.recipes.stream().map(recipe -> DrinkWorkstationMenu.getQuickMoveSlot((DrinkWorkstationRecipe)recipe.comp_1933(), stack)).anyMatch(Optional::isPresent);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.field_22479 && super.method_7613(stack, slot);
    }
}

