package ml.pluto7073.pdapi.specialty;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.component.DrinkAdditions;
import ml.pluto7073.pdapi.component.PDComponents;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import org.jetbrains.annotations.Nullable;

import java.util.*;

@class_6328
public class SpecialtyDrink {

    public static SpecialtyDrink EMPTY = new SpecialtyDrink(class_1802.field_8162, new ArrayList<>(), new ArrayList<>(), 0xf918c5, new HashMap<>(), null);

    public static final Codec<SpecialtyDrink> CODEC =
            PDRegistries.SPECIALTY_DRINK_SERIALIZER.method_39673().dispatch(SpecialtyDrink::serializer, SpecialtyDrinkSerializer::codec);

    public static final Codec<SpecialtyDrink> COMPONENT_CODEC =
            class_2960.field_25139.xmap(SpecialtyDrinkManager::get, SpecialtyDrinkManager::getId);

    public static final class_9139<class_9129, SpecialtyDrink> STREAM_CODEC =
            class_9135.method_56365(PDRegistries.SPECIALITY_DRINK_SERIALIZER_KEY).method_56440(SpecialtyDrink::serializer, SpecialtyDrinkSerializer::streamCodec);

    public static final class_9139<class_9129, SpecialtyDrink> STREAM_COMPONENT_CODEC =
            class_9139.method_56437(class_9135.method_56896(COMPONENT_CODEC), class_9135.method_56896(COMPONENT_CODEC));

    private final class_1792 base;
    private final class_2960[] steps;
    private final OnDrinkAction[] actions;
    private final int color;
    private final Map<String, Integer> chemicals;
    private final String name;

    public SpecialtyDrink(class_1792 base, List<class_2960> steps, List<OnDrinkAction> actions, int color, Map<String, Integer> chemicals, @Nullable String name) {
        this.base = base;
        this.steps = steps.toArray(class_2960[]::new);
        this.actions = actions.toArray(OnDrinkAction[]::new);
        this.color = color;
        this.chemicals = new HashMap<>(chemicals);
        ConsumableChemicalRegistry.fillChemicalMap(this.chemicals);
        this.name = name;
    }

    public String languageKey() {
        return id().method_42093("drink");
    }

    public class_2960 id() {
        return SpecialtyDrinkManager.getId(this);
    }

    public class_1792 base() {
        return base;
    }

    public List<class_2960> steps() {
        return List.of(steps);
    }

    public List<OnDrinkAction> actions() {
        return List.of(actions);
    }

    public int color() {
        return color;
    }

    public Map<String, Integer> chemicals() {
        return chemicals;
    }

    public String name() {
        return name == null || name.isEmpty() ? languageKey() : name;
    }

    public class_2960 type() {
        return PDAPI.asId("specialty_drink");
    }

    public SpecialtyDrinkSerializer serializer() {
        return SpecialtyDrinkSerializer.DEFAULT_SERIALIZER;
    }

    public class_1799 getAsItem() {
        return DrinkUtil.setSpecialDrink(new class_1799(PDItems.SPECIALTY_DRINK, 1), this);
    }

    public class_1799 getAsOriginalItemWithAdditions(class_1799 source) {
        class_1799 stack = new class_1799(base);
        stack.method_57379(PDComponents.ADDITIONS, DrinkAdditions.or(DrinkAdditions.of(steps()), source.method_57825(PDComponents.ADDITIONS, DrinkAdditions.EMPTY)));
        return stack;
    }

    public boolean matches(class_1263 container) {
        class_1799 currentResult = container.method_5438(0);
        if (!currentResult.method_31574(base)) return false;
        List<class_2960> additions = currentResult.method_57825(PDComponents.ADDITIONS, DrinkAdditions.EMPTY)
                .additions().stream().map(DrinkAdditionManager::getId).toList();
        if (steps.length != additions.size()) return false;
        for (int i = 0; i < additions.size(); i++) {
            class_2960 actual = additions.get(i);
            class_2960 wanted = steps[i];
            if (!actual.equals(wanted)) return false;
        }
        return true;
    }

    public List<class_1856> stepsToIngredientList() {
        List<class_1856> ingredients = new ArrayList<>();
        for (class_2960 addition : steps) {
            ingredients.add(DrinkUtil.additionToIngredient(addition));
        }
        return ingredients;
    }

    public static class BaseSerializer implements SpecialtyDrinkSerializer {

        public static final MapCodec<SpecialtyDrink> CODEC = RecordCodecBuilder.mapCodec(instance ->
                instance.group(class_7923.field_41178.method_39673().fieldOf("base").forGetter(SpecialtyDrink::base),
                                Codec.list(class_2960.field_25139).fieldOf("additions").forGetter(SpecialtyDrink::steps),
                                Codec.list(OnDrinkAction.CODEC).fieldOf("onDrinkActions").forGetter(SpecialtyDrink::actions),
                                Codec.INT.fieldOf("color").forGetter(SpecialtyDrink::color),
                                Codec.simpleMap(Codec.STRING, Codec.INT, Keyable.forStrings(() -> ConsumableChemicalRegistry.ids().stream()))
                                        .orElse(new HashMap<>()).fieldOf("chemicals").forGetter(SpecialtyDrink::chemicals),
                                Codec.STRING.fieldOf("name").orElse("").forGetter(SpecialtyDrink::name))
                        .apply(instance, SpecialtyDrink::new));

        public static final class_9139<class_9129, SpecialtyDrink> STREAM_CODEC =
                class_9139.method_56437(BaseSerializer::toNetwork, BaseSerializer::fromNetwork);

        @Override
        public MapCodec<SpecialtyDrink> codec() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SpecialtyDrink> streamCodec() {
            return STREAM_CODEC;
        }

        public static SpecialtyDrink fromNetwork(class_9129 buf) {
            class_2960 base = buf.method_10810();
            List<class_2960> steps = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810);
            HashMap<String, Integer> chemicals = Maps.newHashMap(buf.method_34067(class_2540::method_19772, class_2540::readInt));
            int color = buf.readInt();
            List<OnDrinkAction> list = OnDrinkAction.STREAM_CODEC.method_56433(class_9135.method_56363()).decode(buf);
            String name = buf.method_19772();
            return new SpecialtyDrink(class_7923.field_41178.method_10223(base), steps, list, color, chemicals, name);
        }

        public static void toNetwork(class_9129 buf, SpecialtyDrink drink) {
            buf.method_10812(class_7923.field_41178.method_10221(drink.base));
            NetworkingUtils.arrayToNetwork(buf, drink.steps, class_2540::method_10812);
            buf.method_34063(drink.chemicals, class_2540::method_10814, class_2540::method_53002);
            buf.method_53002(drink.color);
            OnDrinkAction.STREAM_CODEC.method_56433(class_9135.method_56363()).encode(buf, drink.actions());
            buf.method_10814(Objects.requireNonNullElse(drink.name, ""));
        }

    }

}
