package ml.pluto7073.pdapi.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.component.DrinkAdditions;
import ml.pluto7073.pdapi.component.PDComponents;
import ml.pluto7073.pdapi.item.AbstractCustomizableDrinkItem;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.recipes.DrinkWorkstationRecipe;
import ml.pluto7073.pdapi.recipes.PDRecipeTypes;
import ml.pluto7073.pdapi.specialty.SpecialtyDrink;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8786;
import java.util.*;
import java.util.function.Function;

public final class DrinkUtil {

    private static final HashMap<String, Converter<class_2520>> OLD_CONVERSION_REGISTRY = new HashMap<>();
    private static final double CAFFEINE_HALF_LIFE_TICKS = 2500.0;

    public static class_2960 getAsId(class_2960 file, String dir) {
        return file.method_45134(s -> s.replace(dir + '/', "").replace(".json", ""));
    }

    public static <T> Comparator<T> alphabetizer(Function<T, String> toString) {
        return (o1, o2) -> {
            String first = toString.apply(o1);
            String second = toString.apply(o2);
            int length = Math.min(first.length(), second.length());
            for (int i = 0; i < length; i++) {
                char c1 = first.charAt(i);
                char c2 = second.charAt(i);
                if (c1 == c2) continue;
                return Character.compare(c1, c2);
            }
            return Integer.compare(first.length(), second.length());
        };
    }

    public static boolean dev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static <T> List<T> condense(List<T> base) {
        ArrayList<T> list = new ArrayList<>();

        for (T t : base) {
            if (list.isEmpty()) {
                list.add(t);
                continue;
            }
            if (t.equals(list.getLast())) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> boolean sameItems(T[] array1, T[] array2) {
        if (array1 == array2) return true;
        if (array1 == null || array2 == null) return false;
        if (array1.length != array2.length) return false;
        List<T> list1 = List.of(array1);
        List<T> list2 = Lists.newArrayList(array2);
        for (T t1 : list1) {
            if (!list2.contains(t1)) return false;
            list2.remove(t1);
        }
        return list2.isEmpty();
    }

    private static void handleCompound(Stack<String> currentPath, class_2487 compound) {
        for (String key : compound.method_10541()) {
            class_2520 element = compound.method_10580(key);
            if (element == null) continue;
            currentPath.push(key);
            String current = convertPathStackToString(currentPath);
            if (OLD_CONVERSION_REGISTRY.containsKey(current)) {
                element = OLD_CONVERSION_REGISTRY.get(current).convert(element);
                compound.method_10566(key, element);
                continue;
            }
            if (element.method_10711() == class_2487.field_33260) {
                handleCompound(currentPath, (class_2487) element);
            }
            currentPath.pop();
        }
    }

    public static class_1263 copyContainerContents(class_1263 source) {
        class_1263 container = new class_1277(source.method_5439());
        for (int i = 0; i < source.method_5439(); i++) {
            container.method_5447(i, source.method_5438(i).method_7972());
        }
        return container;
    }

    public static DrinkAddition[] getAdditionsFromStack(class_1799 stack) {
        DrinkAdditions additions = stack.method_57824(PDComponents.ADDITIONS);
        assert additions != null: stack.method_7909() + " doesn't contain 'pdapi:additions'";
        return additions.additions().toArray(new DrinkAddition[0]);
    }

    public static void registerOldToNewConverter(String nbtPath, Converter<class_2520> converter) {
        OLD_CONVERSION_REGISTRY.put(nbtPath, converter);
    }

    private static String convertPathStackToString(Stack<String> stack) {
        if (stack.isEmpty()) return "";
        StringBuilder builder = new StringBuilder(stack.get(0));
        for (int i = 1; i < stack.size(); i++) {
            builder.append("/").append(stack.get(i));
        }
        return builder.toString();
    }

    public static class_2520 stringAsNbt(String s) {
        class_2487 compound = new class_2487();
        compound.method_10582("string", s);
        return compound.method_10580("string");
    }

    public static float calculateCaffeineDecay(int ticks, float originalCaffeine) {
        double exp = Math.pow(0.5, ticks / CAFFEINE_HALF_LIFE_TICKS);
        return (float) (exp * originalCaffeine);
    }

    public static float getPlayerCaffeine(class_1657 player) {
        return ConsumableChemicalRegistry.CAFFEINE.get(player);
    }

    public static SpecialtyDrink getSpecialDrink(class_1799 stack) {
        return stack.method_57825(PDComponents.SPECIALTY_DRINK, SpecialtyDrink.EMPTY);
    }

    public static class_1799 setSpecialDrink(class_1799 stack, SpecialtyDrink drink) {
        stack.method_57379(PDComponents.SPECIALTY_DRINK, drink);
        return stack;
    }

    public static int getDrinkColor(class_1799 stack) {
        if (!stack.method_31574(PDItems.SPECIALTY_DRINK)) return -1;
        try {
            SpecialtyDrink drink = getSpecialDrink(stack);
            return 255 << 24 | drink.color();
        } catch (IllegalArgumentException e) {
            return 0xfff918c5;
        }
    }

    @Environment(EnvType.CLIENT)
    public static class_1856 additionToIngredient(class_2960 additionId) {
        class_1937 level = class_310.method_1551().field_1687;
        if (level == null) {
            PDAPI.LOGGER.warn("Ingredient list for \"{}\" could not be determined cause you are not in a world", additionId);
            return class_1856.field_9017;
        }
        List<class_8786<DrinkWorkstationRecipe>> recipes = level.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE)
                .stream().filter(r -> r.comp_1933().getResult().equals(additionId)).toList();
        if (recipes.isEmpty()) return class_1856.field_9017;
        List<class_1799> matchingStacks = new ArrayList<>();
        recipes.forEach(r -> matchingStacks.addAll(Arrays.asList(r.comp_1933().getAddition().method_8105())));
        if (matchingStacks.isEmpty()) return class_1856.field_9017;
        return class_1856.method_26964(matchingStacks.stream());
    }

    @Environment(EnvType.CLIENT)
    public static class_1856 getValidBasesForAddition(class_2960 additionId) {
        class_1937 level = class_310.method_1551().field_1687;
        if (level == null) {
            PDAPI.LOGGER.warn("Valid bases for \"{}\" can only be retrieved when a level is loaded", additionId);
            return class_1856.field_9017;
        }
        List<class_8786<DrinkWorkstationRecipe>> recipes = level.method_8433().method_30027(PDRecipeTypes.DRINK_WORKSTATION_RECIPE_TYPE)
                .stream().filter(r -> r.comp_1933().getResult().equals(additionId)).toList();
        if (recipes.isEmpty()) return class_1856.field_9017;
        List<class_1799> matchingStacks = new ArrayList<>();
        recipes.forEach(r -> matchingStacks.addAll(Arrays.asList(r.comp_1933().getBase().method_8105())));
        if (matchingStacks.isEmpty()) return class_1856.field_9017;
        return class_1856.method_26964(matchingStacks.stream());
    }

    public interface Converter<T extends class_2520> {
        T convert(T startingElement);
    }

}
