/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.addition;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class DrinkAddition {
    public static final Codec<DrinkAddition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(OnDrinkAction.CODEC).fieldOf("onDrinkActions").orElse(new ArrayList()).forGetter(DrinkAddition::actions), (App)Codec.BOOL.fieldOf("changesColor").orElse((Object)false).forGetter(DrinkAddition::changesColor), (App)Codec.INT.fieldOf("color").orElse((Object)0).forGetter(DrinkAddition::color), (App)Codec.simpleMap((Codec)Codec.STRING, (Codec)Codec.INT, (Keyable)Keyable.forStrings(() -> ConsumableChemicalRegistry.ids().stream())).fieldOf("chemicals").orElse(new HashMap()).forGetter(DrinkAddition::chemicals), (App)Codec.INT.fieldOf("maxAmount").orElse((Object)0).forGetter(DrinkAddition::maxAmount), (App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(addition -> addition.name), (App)Codec.INT.fieldOf("weight").orElse((Object)0).forGetter(DrinkAddition::currentWeight)).apply((Applicative)instance, DrinkAddition::new));
    public static final class_9139<class_9129, DrinkAddition> STREAM_CODEC = class_9139.method_56437((buf, add) -> add.toNetwork((class_9129)buf), DrinkAddition::fromNetwork);
    public static final Codec<DrinkAddition> COMPONENT_CODEC = class_2960.field_25139.xmap(DrinkAdditionManager::get, DrinkAdditionManager::getId);
    private final OnDrinkAction[] actions;
    private final boolean changesColor;
    private final int color;
    private final Map<String, Integer> chemicals;
    private final int maxAmount;
    private final int currentWeight;
    private final String name;

    protected DrinkAddition(List<OnDrinkAction> actions, boolean changesColor, int color, Map<String, Integer> chemicals, int maxAmount, @Nullable String name, int currentWeight) {
        this.actions = (OnDrinkAction[])actions.toArray(OnDrinkAction[]::new);
        this.changesColor = changesColor;
        this.color = color;
        this.chemicals = new HashMap<String, Integer>(chemicals);
        ConsumableChemicalRegistry.fillChemicalMap(this.chemicals);
        this.maxAmount = maxAmount;
        this.currentWeight = currentWeight;
        this.name = name;
    }

    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        for (OnDrinkAction action : this.actions) {
            action.onDrink(stack, level, user);
        }
    }

    public boolean changesColor() {
        return this.changesColor;
    }

    public int color() {
        return this.color;
    }

    public Map<String, Integer> chemicals() {
        return this.chemicals;
    }

    public int maxAmount() {
        return this.maxAmount;
    }

    public int currentWeight() {
        return this.currentWeight;
    }

    public List<OnDrinkAction> actions() {
        return Lists.newArrayList((Object[])this.actions);
    }

    public void toNetwork(class_9129 buf) {
        OnDrinkAction.STREAM_CODEC.method_56433(class_9135.method_56363()).encode((Object)buf, this.actions());
        buf.method_52964(this.changesColor);
        buf.method_53002(this.color);
        buf.method_34063(this.chemicals, class_2540::method_10814, class_2540::method_53002);
        buf.method_53002(this.maxAmount);
        buf.method_53002(this.currentWeight);
        buf.method_10814(Objects.requireNonNullElse(this.name, ""));
    }

    public static DrinkAddition fromNetwork(class_9129 buf) {
        List actions = (List)OnDrinkAction.STREAM_CODEC.method_56433(class_9135.method_56363()).decode((Object)buf);
        boolean changesColor = buf.readBoolean();
        int color = buf.readInt();
        Map chemicals = buf.method_34067(class_2540::method_19772, class_2540::readInt);
        int maxAmount = buf.readInt();
        int currentWeight = buf.readInt();
        String name = buf.method_19772();
        if (name.isEmpty()) {
            name = null;
        }
        return new DrinkAddition(actions, changesColor, color, chemicals, maxAmount, name, currentWeight);
    }

    public String getTranslationKey() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        try {
            class_2960 id = DrinkAdditionManager.getId(this);
            return id.method_42093("drink_addition");
        }
        catch (IllegalArgumentException e) {
            PDAPI.LOGGER.error("Couldn't get translation key for a drink addition", (Throwable)e);
            return "drink_addition.pdapi.empty";
        }
    }

    public static class Builder {
        private final List<OnDrinkAction> actions = new ArrayList<OnDrinkAction>();
        private boolean changesColor = false;
        private int color = 0;
        private final HashMap<String, Integer> chemicals = new HashMap();
        private int maxAmount;
        private int weight;
        private String name;

        public Builder() {
            ConsumableChemicalRegistry.forEach(handler -> this.chemical(handler.getName(), 0));
            this.maxAmount = 0;
            this.weight = 0;
            this.name = null;
        }

        public Builder addAction(OnDrinkAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder changesColor(boolean changesColor) {
            this.changesColor = changesColor;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder chemical(String name, int amount) {
            this.chemicals.put(name, amount);
            return this;
        }

        public Builder maxAmount(int amount) {
            this.maxAmount = amount;
            return this;
        }

        public Builder setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public DrinkAddition build() {
            return new DrinkAddition(this.actions, this.changesColor, this.color, this.chemicals, this.maxAmount, this.name, this.weight);
        }
    }
}

