/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi.item;

import java.util.List;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.chemicals.ConsumableChemicalRegistry;
import ml.pluto7073.pdapi.component.DrinkAdditions;
import ml.pluto7073.pdapi.component.PDComponents;
import ml.pluto7073.pdapi.util.DrinkUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6328;
import net.minecraft.class_6880;

@class_6328
public abstract class AbstractCustomizableDrinkItem
extends class_1792 {
    public static final String DRINK_DATA_NBT_KEY = "DrinkData";
    private static final int MAX_USE_TIME = 32;
    protected final Temperature baseTemperature;
    protected final class_1792 baseItem;

    protected AbstractCustomizableDrinkItem(class_1792 baseItem, Temperature baseTemperature, class_1792.class_1793 settings) {
        super(settings);
        this.baseTemperature = baseTemperature;
        this.baseItem = baseItem;
    }

    public Temperature getDrinkTemperature(class_1799 stack) {
        return this.baseTemperature;
    }

    public int getChemicalContent(String name, class_1799 stack) {
        int amount = 0;
        for (DrinkAddition a : DrinkUtil.getAdditionsFromStack(stack)) {
            amount += a.chemicals().get(name).intValue();
        }
        return amount;
    }

    public int method_7881(class_1799 stack) {
        return 32;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 player;
        class_1657 class_16572 = player = user instanceof class_1657 ? (class_1657)user : null;
        if (player instanceof class_3222) {
            class_174.field_1198.method_8821((class_3222)player, stack);
        }
        if (!world.field_9236) {
            DrinkAddition[] additions;
            for (DrinkAddition addition : additions = DrinkUtil.getAdditionsFromStack(stack)) {
                addition.onDrink(stack, world, user);
            }
            if (player != null) {
                ConsumableChemicalRegistry.forEach(handler -> {
                    float amount = this.getChemicalContent(handler.getName(), stack);
                    if (amount > 0.0f) {
                        handler.add(player, amount);
                    }
                });
            }
        }
        if (player != null) {
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }
        if (player == null || !player.method_31549().field_7477) {
            if (stack.method_7960()) {
                return new class_1799((class_1935)this.baseItem);
            }
            if (player != null) {
                player.method_31548().method_7394(new class_1799((class_1935)this.baseItem));
            }
        }
        user.method_32876((class_6880)class_5712.field_28734);
        return stack;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 config) {
        super.method_7851(stack, context, tooltip, config);
        if (config.method_8035() || config.method_47370()) {
            ConsumableChemicalRegistry.forEach(handler -> handler.appendTooltip(tooltip, this.getChemicalContent(handler.getName(), stack), stack));
        }
        ((DrinkAdditions)stack.method_57825(PDComponents.ADDITIONS, (Object)DrinkAdditions.EMPTY)).method_57409(context, tooltip::add, config);
    }

    public static enum Temperature {
        BURNT,
        HOT,
        NORMAL,
        COLD,
        FROZEN;

    }
}

