/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.pdapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.addition.DrinkAdditions;
import ml.pluto7073.pdapi.entity.PDTrackedData;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public final class DrinkUtil {
    private static final HashMap<String, Converter> OLD_CONVERSION_REGISTRY = new HashMap();
    private static final double CAFFEINE_HALF_LIFE_TICKS = 2500.0;

    public static int getCoffeeColour(class_1799 stack) {
        DrinkUtil.convertStackFromPlutosCoffee(stack);
        DrinkAddition[] addIns = DrinkUtil.getAdditionsFromStack(stack);
        if (addIns == null) {
            return 0;
        }
        return DrinkUtil.getCoffeeColour(addIns);
    }

    public static int getCoffeeColour(DrinkAddition[] addIns) {
        boolean colour = false;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int colourCount = 1;
        int allowedMilk = 3;
        for (DrinkAddition addition : addIns) {
            if (!addition.changesColor()) continue;
            if (DrinkAdditions.getId(addition).toString().equals("pdapi:milk") && allowedMilk > 0) {
                --allowedMilk;
                continue;
            }
            int additionColour = addition.getColor();
            r += (float)(additionColour >> 16 & 0xFF) / 255.0f;
            g += (float)(additionColour >> 8 & 0xFF) / 255.0f;
            b += (float)(additionColour & 0xFF) / 255.0f;
            ++colourCount;
        }
        r = r / (float)colourCount * 255.0f;
        g = g / (float)colourCount * 255.0f;
        b = b / (float)colourCount * 255.0f;
        return (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static void convertStackFromPlutosCoffee(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("Coffee")) {
            return;
        }
        Stack<String> currentPath = new Stack<String>();
        currentPath.push("Coffee");
        class_2487 oldCoffeeData = nbt.method_10562("Coffee");
        DrinkUtil.handleCompound(currentPath, oldCoffeeData);
        nbt.method_10566("DrinkData", (class_2520)oldCoffeeData);
        nbt.method_10551("Coffee");
    }

    private static void handleCompound(Stack<String> currentPath, class_2487 compound) {
        for (String key : compound.method_10541()) {
            class_2520 element = compound.method_10580(key);
            if (element == null) continue;
            currentPath.push(key);
            String current = DrinkUtil.convertPathStackToString(currentPath);
            if (OLD_CONVERSION_REGISTRY.containsKey(current)) {
                element = OLD_CONVERSION_REGISTRY.get(current).convert(element);
                compound.method_10566(key, element);
                continue;
            }
            if (element.method_10711() == 10) {
                DrinkUtil.handleCompound(currentPath, (class_2487)element);
            }
            currentPath.pop();
        }
    }

    public static DrinkAddition[] getAdditionsFromStack(class_1799 stack) {
        DrinkUtil.convertStackFromPlutosCoffee(stack);
        class_2487 drinkData = stack.method_7911("DrinkData");
        class_2499 additions = drinkData.method_10554("Additions", 8);
        ArrayList<DrinkAddition> additionsList = new ArrayList<DrinkAddition>();
        for (int i = 0; i < additions.size(); ++i) {
            String id = additions.method_10608(i);
            class_2960 identifier = new class_2960(id);
            additionsList.add(DrinkAdditions.get(identifier));
        }
        return additionsList.toArray(new DrinkAddition[0]);
    }

    public static void registerOldToNewConverter(String nbtPath, Converter converter) {
        OLD_CONVERSION_REGISTRY.put(nbtPath, converter);
    }

    private static String convertPathStackToString(Stack<String> stack) {
        if (stack.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder((String)stack.get(0));
        for (int i = 1; i < stack.size(); ++i) {
            builder.append("/").append((String)stack.get(i));
        }
        return builder.toString();
    }

    public static class_2520 stringAsNbt(String s) {
        class_2487 compound = new class_2487();
        compound.method_10582("string", s);
        return compound.method_10580("string");
    }

    public static void setPlayerCaffeine(class_1657 player, float caffeine) {
        player.method_5841().method_12778(PDTrackedData.PLAYER_TICKS_SINCE_LAST_CAFFEINE, (Object)0);
        player.method_5841().method_12778(PDTrackedData.PLAYER_CAFFEINE_AMOUNT, (Object)Float.valueOf(caffeine));
        player.method_5841().method_12778(PDTrackedData.PLAYER_ORIGINAL_CAFFEINE_AMOUNT, (Object)Float.valueOf(caffeine));
    }

    public static float calculateCaffeineDecay(int ticks, float originalCaffeine) {
        double exp = Math.pow(0.5, (double)ticks / 2500.0);
        return (float)(exp * (double)originalCaffeine);
    }

    public static float getPlayerCaffeine(class_1657 player) {
        return ((Float)player.method_5841().method_12789(PDTrackedData.PLAYER_CAFFEINE_AMOUNT)).floatValue();
    }

    public static interface Converter<T extends class_2520> {
        public T convert(T var1);
    }
}

