package ml.pluto7073.plutonium.config;

import ml.pluto7073.plutonium.networking.serverbound.ServerboundPackets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.nbt.*;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

import java.util.HashMap;

public class ServerConfig extends AbstractConfig {

    protected boolean copy = false;
    protected ServerConfigType type;

    public ServerConfig(String modid, Logger logger) {
        super(modid, "server", logger);
    }

    public ServerConfigType getType() {
        return type;
    }

    public class_2487 serialize() {
        class_2487 serialized = new class_2487();

        for (String key : fields.keySet()) {
            OptionInstance inst = fields.get(key);
            if (inst instanceof BooleanInstance bool) {
                serialized.method_10556(key, bool.getValue());
            } else if (inst instanceof DoubleInstance d) {
                serialized.method_10549(key, d.getValue());
            } else if (inst instanceof EnumInstance e) {
                serialized.method_10582(key, e.getValueStr());
            } else if (inst instanceof IntInstance i) {
                serialized.method_10569(key, i.getValue());
            } else if (inst instanceof LongInstance l) {
                serialized.method_10544(key, l.getValue());
            } else if (inst instanceof StringInstance str) {
                serialized.method_10582(key, str.getValue());
            }
        }

        return serialized;
    }

    public void writeToPacket(class_2540 buf) {
        buf.method_10794(serialize());
    }

    public final void saveRaw() {
        if (!copy) save();
    }

    @Override
    public void load() {
        if (!copy) {
            super.load();
        }
    }

    @Override
    public void save() {
        if (!copy) {
            super.save();
        } else if (type == null || !type.isManaged()) {
            ServerboundPackets.UpdateConfigPacket packet = new ServerboundPackets.UpdateConfigPacket(this);
            ClientPlayNetworking.send(packet);
        }
    }

    public void loadFromTag(class_2487 serialized) {
        HashMap<String, Object> deserialized = new HashMap<>();

        for (String key : serialized.method_10541()) {
            class_2520 tag = serialized.method_10580(key);
            if (tag instanceof class_2514 d) {
                deserialized.put(key, d.method_10702());
            } else if (tag instanceof class_2519 str) {
                deserialized.put(key, str.method_10714());
            }
        }

        loadValues(deserialized, false);

        saveRaw();
    }

    public void loadFromPacket(class_2540 buf) {
        class_2487 serialized = buf.method_30617();
        if (serialized == null) return;
        loadFromTag(serialized);
    }

}
