/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.plutonium.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.pluto7073.plutonium.annotations.BooleanOption;
import ml.pluto7073.plutonium.annotations.DoubleOption;
import ml.pluto7073.plutonium.annotations.EnumOption;
import ml.pluto7073.plutonium.annotations.IntOption;
import ml.pluto7073.plutonium.annotations.LongOption;
import ml.pluto7073.plutonium.annotations.StringOption;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final Map<String, OptionInstance> fields;
    public final String configName;
    public final Logger logger;

    public AbstractConfig(String modid, String name, Logger logger) {
        HashMap<String, BooleanInstance> fields = new HashMap<String, BooleanInstance>();
        this.configName = modid + "_" + name;
        this.logger = logger;
        for (Field field : this.getClass().getFields()) {
            OptionInstance instance = null;
            if (field.isAnnotationPresent(BooleanOption.class)) {
                instance = new BooleanInstance(field, field.getAnnotation(BooleanOption.class));
            } else if (field.isAnnotationPresent(DoubleOption.class)) {
                instance = new DoubleInstance(field, field.getAnnotation(DoubleOption.class));
            } else if (field.isAnnotationPresent(EnumOption.class)) {
                instance = new EnumInstance(field, field.getAnnotation(EnumOption.class));
            } else if (field.isAnnotationPresent(IntOption.class)) {
                instance = new IntInstance(field, field.getAnnotation(IntOption.class));
            } else if (field.isAnnotationPresent(LongOption.class)) {
                instance = new LongInstance(field, field.getAnnotation(LongOption.class));
            } else if (field.isAnnotationPresent(StringOption.class)) {
                instance = new StringInstance(field, field.getAnnotation(StringOption.class));
            }
            if (instance == null) continue;
            if (!field.canAccess(this)) {
                throw new RuntimeException("Unable to access field " + field.getName() + ", field must be public and non-final");
            }
            fields.put(field.getName(), (BooleanInstance)instance);
        }
        this.fields = ImmutableMap.copyOf(fields);
    }

    @Nullable
    public List<Pair<String, Map<String, OptionInstance>>> getSubCategories() {
        return null;
    }

    @Nullable
    public Map<String, String> getSubCategoryNames() {
        return null;
    }

    public void load() {
        File cfgFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.configName + ".json");
        if (!cfgFile.exists()) {
            this.loadValues(Maps.newHashMap());
            return;
        }
        try (FileReader reader = new FileReader(cfgFile);){
            JsonObject data = class_3518.method_15255((Reader)reader);
            HashMap<String, Object> deserialized = new HashMap<String, Object>();
            for (String s : data.keySet()) {
                JsonElement value = data.get(s);
                if (!(value instanceof JsonPrimitive)) continue;
                JsonPrimitive prim = (JsonPrimitive)value;
                if (prim.isBoolean()) {
                    deserialized.put(s, prim.getAsBoolean());
                    continue;
                }
                if (prim.isString()) {
                    deserialized.put(s, prim.getAsString());
                    continue;
                }
                if (!prim.isNumber()) continue;
                deserialized.put(s, prim.getAsNumber());
            }
            this.loadValues(deserialized);
        }
        catch (Exception e) {
            this.logger.error("Failed to load config {}", (Object)this.configName, (Object)e);
            this.loadValues(Maps.newHashMap());
        }
    }

    public void save() {
        File cfgFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.configName + ".json");
        if (!cfgFile.exists()) {
            try {
                cfgFile.createNewFile();
            }
            catch (IOException e) {
                this.logger.error("Failed to create config file for {}", (Object)this.configName, (Object)e);
                return;
            }
        }
        JsonObject serialized = new JsonObject();
        for (String key : this.fields.keySet()) {
            OptionInstance inst = this.fields.get(key);
            if (inst instanceof BooleanInstance) {
                BooleanInstance bool = (BooleanInstance)inst;
                serialized.addProperty(key, Boolean.valueOf(bool.getValue()));
                continue;
            }
            if (inst instanceof DoubleInstance) {
                DoubleInstance d = (DoubleInstance)inst;
                serialized.addProperty(key, (Number)d.getValue());
                continue;
            }
            if (inst instanceof EnumInstance) {
                EnumInstance e = (EnumInstance)inst;
                serialized.addProperty(key, e.getValueStr());
                continue;
            }
            if (inst instanceof IntInstance) {
                IntInstance i = (IntInstance)inst;
                serialized.addProperty(key, (Number)i.getValue());
                continue;
            }
            if (inst instanceof LongInstance) {
                LongInstance l = (LongInstance)inst;
                serialized.addProperty(key, (Number)l.getValue());
                continue;
            }
            if (!(inst instanceof StringInstance)) continue;
            StringInstance str = (StringInstance)inst;
            serialized.addProperty(key, str.getValue());
        }
        try (FileWriter writer = new FileWriter(cfgFile);){
            GSON.toJson((JsonElement)serialized, (Appendable)writer);
        }
        catch (Exception e) {
            this.logger.error("Failed to save config for {}", (Object)this.configName, (Object)e);
        }
    }

    public Map<String, OptionInstance> getFields() {
        return this.fields;
    }

    public void loadValues(Map<String, Object> values) {
        this.loadValues(values, true);
    }

    public void loadValues(Map<String, Object> values, boolean reset) {
        for (String field : this.fields.keySet()) {
            if (values.containsKey(field)) {
                this.fields.get(field).setValue(values.get(field));
                continue;
            }
            if (!reset) continue;
            this.fields.get(field).setValue(this.fields.get(field).getDefaultVal());
        }
    }

    public class BooleanInstance
    extends OptionInstance {
        protected final boolean defaultVal;
        protected final boolean hasTooltip;

        protected BooleanInstance(Field field, BooleanOption data) {
            super(field);
            if (field.getType() != Boolean.class && field.getType() != Boolean.TYPE) {
                throw new IllegalArgumentException("@BooleanOption only allowed on Boolean type fields");
            }
            this.defaultVal = data.defaultVal();
            this.hasTooltip = data.hasTooltip();
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        public boolean getValue() {
            return (Boolean)this.getRawValue();
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Byte) {
                Byte b = (Byte)value;
                super.setValue(b == 1);
            } else if (value instanceof Integer) {
                Integer i = (Integer)value;
                super.setValue(i == 1);
            } else {
                super.setValue(value);
            }
        }
    }

    public class DoubleInstance
    extends OptionInstance {
        protected final double minVal;
        protected final double maxVal;
        protected final double defaultVal;
        protected final boolean hasTooltip;

        protected DoubleInstance(Field field, DoubleOption data) {
            super(field);
            this.minVal = data.min();
            this.maxVal = data.max();
            this.defaultVal = data.defaultVal();
            this.hasTooltip = data.hasTooltip();
            if (field.getType() != Double.class && field.getType() != Double.TYPE) {
                throw new IllegalArgumentException("@DoubleOption only allowed on Double type fields");
            }
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Double)) {
                if (value instanceof Number) {
                    Number n = (Number)value;
                    super.setValue(n.doubleValue());
                } else {
                    super.setValue(Double.parseDouble(value.toString()));
                }
            } else {
                Double d = (Double)value;
                super.setValue(d);
            }
        }

        public double getMinVal() {
            return this.minVal;
        }

        public double getMaxVal() {
            return this.maxVal;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        public double getValue() {
            return (Double)this.getRawValue();
        }
    }

    public class EnumInstance
    extends OptionInstance {
        protected final Class<? extends Enum<?>> enumClass;
        protected final Object defaultVal;
        protected final boolean hasTooltip;

        protected EnumInstance(Field field, EnumOption data) {
            super(field);
            this.enumClass = field.getType();
            this.defaultVal = this.getEnumConstant(data.value());
            this.hasTooltip = data.hasTooltip();
        }

        public Class<? extends Enum<?>> getEnumClass() {
            return this.enumClass;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                super.setValue(this.getEnumConstant(name));
            } else {
                super.setValue(value);
            }
        }

        private Enum<?> getEnumConstant(String name) {
            Enum<?> val = null;
            for (Enum<?> enumConstant : this.enumClass.getEnumConstants()) {
                if (!enumConstant.name().equals(name)) continue;
                val = enumConstant;
            }
            if (val == null) {
                throw new IllegalArgumentException("Couldn't find enum value " + name + " in enum class " + this.enumClass.getTypeName());
            }
            return val;
        }

        public Enum<?> getValue() {
            return (Enum)this.getRawValue();
        }

        public String getValueStr() {
            return this.getValue().name();
        }
    }

    public class IntInstance
    extends OptionInstance {
        protected final int minVal;
        protected final int maxVal;
        protected final int defaultVal;
        protected final boolean hasTooltip;

        protected IntInstance(Field field, IntOption data) {
            super(field);
            this.minVal = data.min();
            this.maxVal = data.max();
            this.defaultVal = data.defaultVal();
            this.hasTooltip = data.hasTooltip();
            if (field.getType() != Integer.TYPE && field.getType() != Integer.class) {
                throw new IllegalArgumentException("@IntOption only allowed on int type fields");
            }
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Integer)) {
                if (value instanceof Number) {
                    Number n = (Number)value;
                    super.setValue(n.intValue());
                } else {
                    super.setValue(Integer.parseInt(value.toString()));
                }
            } else {
                Integer i = (Integer)value;
                super.setValue(i);
            }
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        public int getMinVal() {
            return this.minVal;
        }

        public int getMaxVal() {
            return this.maxVal;
        }

        public int getValue() {
            return (Integer)this.getRawValue();
        }
    }

    public class LongInstance
    extends OptionInstance {
        protected final long minVal;
        protected final long maxVal;
        protected final long defaultVal;
        protected final boolean hasTooltip;

        protected LongInstance(Field field, LongOption data) {
            super(field);
            this.minVal = data.min();
            this.maxVal = data.max();
            this.defaultVal = data.defaultVal();
            this.hasTooltip = data.hasTooltip();
            if (field.getType() != Long.TYPE && field.getType() != Long.class) {
                throw new IllegalArgumentException("@LongOption only allowed on long type fields");
            }
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Long)) {
                if (value instanceof Number) {
                    Number n = (Number)value;
                    super.setValue(n.longValue());
                } else {
                    super.setValue(Long.parseLong(value.toString()));
                }
            } else {
                Long l = (Long)value;
                super.setValue(l);
            }
        }

        public long getMinVal() {
            return this.minVal;
        }

        public long getMaxVal() {
            return this.maxVal;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        public long getValue() {
            return (Long)this.getRawValue();
        }
    }

    public class StringInstance
    extends OptionInstance {
        protected final String defaultVal;
        protected final int maxLength;
        protected final boolean hasTooltip;

        protected StringInstance(Field field, StringOption data) {
            super(field);
            this.defaultVal = data.defaultVal();
            this.maxLength = data.maxLength();
            this.hasTooltip = data.hasTooltip();
            if (field.getType() != String.class) {
                throw new IllegalArgumentException("@StringOption only allowed on String type fields");
            }
        }

        @Override
        public boolean hasTooltip() {
            return this.hasTooltip;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        public String getValue() {
            return (String)this.getRawValue();
        }
    }

    public abstract class OptionInstance {
        protected Field field;

        protected OptionInstance(Field field) {
            this.field = field;
        }

        public void setValue(Object value) {
            try {
                this.field.set(AbstractConfig.this, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set config value", e);
            }
        }

        protected Object getRawValue() {
            try {
                return this.field.get(AbstractConfig.this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to retrieve config value", e);
            }
        }

        public abstract Object getDefaultVal();

        public abstract boolean hasTooltip();
    }
}

