/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.plutonium.config;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.pluto7073.plutonium.config.AbstractConfig;
import ml.pluto7073.plutonium.config.ClientConfig;
import org.apache.logging.log4j.Logger;

public class JointClientConfig
extends ClientConfig {
    private final List<ClientConfig> managedConfigs = new ArrayList<ClientConfig>();

    public JointClientConfig(String modid, Logger logger, ClientConfig ... managedConfigs) {
        super(modid, logger);
        for (ClientConfig managedConfig : managedConfigs) {
            if (managedConfig.isManaged()) continue;
            throw new IllegalArgumentException("ClientConfig " + managedConfig.configName + " cannot be added to a JointConfig because it isn't managed");
        }
        this.managedConfigs.addAll(List.of(managedConfigs));
    }

    public void addManagedConfig(ClientConfig config) {
        if (!config.isManaged()) {
            throw new IllegalArgumentException("ClientConfig " + config.configName + " cannot be added to JointConfig as it is not managed");
        }
        this.managedConfigs.add(config);
    }

    @Override
    public void save() {
        super.save();
        this.managedConfigs.forEach(AbstractConfig::save);
    }

    @Override
    public void load() {
        super.load();
        this.managedConfigs.forEach(AbstractConfig::load);
    }

    @Override
    public Map<String, AbstractConfig.OptionInstance> getFields() {
        HashMap allFields = new HashMap(this.fields);
        for (ClientConfig config : this.managedConfigs) {
            allFields.putAll(config.fields);
        }
        return ImmutableMap.copyOf(allFields);
    }
}

