package ml.pluto7073.plutonium.client.gui;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import ml.pluto7073.plutonium.config.AbstractConfig;
import ml.pluto7073.plutonium.config.ClientConfig;
import ml.pluto7073.plutonium.config.ServerConfig;
import ml.pluto7073.plutonium.config.ServerConfigType;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import java.util.Locale;
import java.util.function.Function;

/**
 * Requires ClothConfig for this functionality to work
 */
public class PlutoniumConfigScreen implements Function<class_437, class_437> {

    private final ClientConfig client;
    private final ServerConfigType<?> serverType;
    private final String modid;

    public PlutoniumConfigScreen(ClientConfig client, ServerConfigType<?> serverType, String modid) {
        this.client = client;
        this.serverType = serverType;
        this.modid = modid;
    }

    @Override
    public class_437 apply(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create()
                .setParentScreen(parent)
                .setTitle(class_2561.method_43471("title." + modid + ".config"))
                .setDefaultBackgroundTexture(new class_2960("minecraft:textures/gui/options_background.png"));

        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        if (client != null) {
            ConfigCategory clientCategory =
                    builder.getOrCreateCategory(class_2561.method_43471("title.plutonium.client"));

            if (client.getSubCategories() != null) {

            } else {
                client.getFields().forEach((key, instance) ->
                        addConfigEntry(client, "client." + key, instance, clientCategory, entryBuilder));
            }
        }

        ServerConfig server = null;

        if (serverType != null && class_310.method_1551().method_1562() == null) {
            server = serverType.serverConfig;
        } else if (serverType != null && class_310.method_1551().field_1724 != null && (class_310.method_1551().field_1724.method_5687(2) || class_310.method_1551().method_1496())) {
            server = serverType.getCopy();
        }

        ServerConfig cfg = server;

        if (server != null) {
            ConfigCategory serverCategory =
                    builder.getOrCreateCategory(class_2561.method_43471("title.plutonium.server"));

            server.getFields().forEach((key, instance) ->
                    addConfigEntry(cfg, "common." + key, instance, serverCategory, entryBuilder));
        }

        builder.setSavingRunnable(() -> {
            if (client != null) {
                client.save();
            }
            if (cfg != null) {
                cfg.save();
            }
        });

        return builder.build();
    }

    private void addFromSubCategories(AbstractConfig config, ConfigCategory category, ConfigEntryBuilder builder) {

    }

    private void addConfigEntry(AbstractConfig config, String key, AbstractConfig.OptionInstance instance, ConfigCategory category, ConfigEntryBuilder builder) {
        if (instance instanceof AbstractConfig.BooleanInstance bool) {
            category.addEntry(builder.startBooleanToggle(translatable(config.modid, key), bool.getValue())
                    .setDefaultValue((boolean) bool.getDefaultVal())
                    .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                    .setSaveConsumer(bool::setValue)
                    .build());
        } else if (instance instanceof AbstractConfig.DoubleInstance doubleInst) {
            category.addEntry(builder.startDoubleField(translatable(config.modid, key), doubleInst.getValue())
                    .setDefaultValue((double) doubleInst.getDefaultVal())
                    .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                    .setSaveConsumer(d -> {
                        doubleInst.setValue(d > doubleInst.getMaxVal() && doubleInst.getMaxVal() > doubleInst.getMinVal() ? doubleInst.getMaxVal() :
                                (d < doubleInst.getMinVal() && doubleInst.getMaxVal() > doubleInst.getMinVal() ? doubleInst.getMinVal() : d));
                    })
                    .build());
        } else if (instance instanceof AbstractConfig.EnumInstance enumInst) {
            //noinspection unchecked
            category.addEntry(builder.startEnumSelector(translatable(config.modid, key), (Class<Enum<?>>) enumInst.getEnumClass(), enumInst.getValue())
                    .setDefaultValue((Enum<?>) enumInst.getDefaultVal())
                    .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                    .setSaveConsumer(enumInst::setValue)
                    .setEnumNameProvider(anEnum -> translatable(config.modid, key + "." + anEnum.name().toLowerCase(Locale.ROOT)))
                    .build());
        } else if (instance instanceof AbstractConfig.IntInstance intInst) {
            if (intInst.getMaxVal() > intInst.getMinVal()) {
                category.addEntry(builder.startIntSlider(translatable(config.modid, key), intInst.getValue(), intInst.getMinVal(), intInst.getMaxVal())
                        .setDefaultValue((Integer) intInst.getDefaultVal())
                        .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                        .setSaveConsumer(intInst::setValue)
                        .build());
            } else {
                category.addEntry(builder.startIntField(translatable(config.modid, key), intInst.getValue())
                        .setDefaultValue((Integer) intInst.getDefaultVal())
                        .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                        .setSaveConsumer(intInst::setValue)
                        .build());
            }
        } else if (instance instanceof AbstractConfig.LongInstance longInst) {
            if (longInst.getMaxVal() > longInst.getMinVal()) {
                category.addEntry(builder.startLongSlider(translatable(config.modid, key), longInst.getValue(), longInst.getMinVal(), longInst.getMaxVal())
                        .setDefaultValue((Long) longInst.getDefaultVal())
                        .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                        .setSaveConsumer(longInst::setValue)
                        .build());
            } else {
                category.addEntry(builder.startLongField(translatable(config.modid, key), longInst.getValue())
                        .setDefaultValue((Long) longInst.getDefaultVal())
                        .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                        .setSaveConsumer(longInst::setValue)
                        .build());
            }
        } else if (instance instanceof AbstractConfig.StringInstance str) {
            category.addEntry(builder.startStrField(translatable(config.modid, key), str.getValue())
                    .setDefaultValue((String) str.getDefaultVal())
                    .setTooltip(instance.hasTooltip() ? translatable(config.modid, key + ".desc") : class_2561.method_43473())
                    .setSaveConsumer(str::setValue)
                    .build());
        }
    }

    private class_2561 translatable(String modid, String name) {
        return class_2561.method_43471("option." + modid + "." + name);
    }

}
