/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.plutonium.config;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.pluto7073.plutonium.PlutoniumConfig;
import ml.pluto7073.plutonium.config.AbstractConfig;
import ml.pluto7073.plutonium.config.ServerConfig;
import ml.pluto7073.plutonium.config.ServerConfigType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Logger;

public class JointServerConfig
extends ServerConfig {
    protected final List<ServerConfigType<?>> managedConfigs;

    public JointServerConfig(String modid, Logger logger, ServerConfigType<?> type, boolean copy, ServerConfigType<?> ... managedConfigs) {
        super(modid, logger, type, copy);
        for (ServerConfigType<?> managedConfig : managedConfigs) {
            if (managedConfig.isManaged()) continue;
            throw new IllegalArgumentException("All configs added to a JointConfig must be managed, " + ((ServerConfig)managedConfig.serverConfig).configName + " is not");
        }
        this.managedConfigs = new ArrayList(List.of(managedConfigs));
    }

    public void addManagedConfig(ServerConfigType<?> ... managedConfigs) {
        for (ServerConfigType<?> managedConfig : managedConfigs) {
            if (managedConfig.isManaged()) continue;
            throw new IllegalArgumentException("All configs added to a JointConfig must be managed, " + ((ServerConfig)managedConfig.serverConfig).configName + " is not");
        }
        this.managedConfigs.addAll(List.of(managedConfigs));
    }

    @Override
    public void save() {
        super.save();
        for (ServerConfigType<?> managedConfig : this.managedConfigs) {
            if (this.copy) continue;
            ((ServerConfig)managedConfig.serverConfig).save();
        }
    }

    @Override
    public void load() {
        super.load();
        for (ServerConfigType<?> managedConfig : this.managedConfigs) {
            if (this.copy) continue;
            ((ServerConfig)managedConfig.serverConfig).load();
        }
    }

    @Override
    public void writeToPacket(class_2540 buf) {
        super.writeToPacket(buf);
        for (ServerConfigType<?> managedConfig : this.managedConfigs) {
            class_2960 key = PlutoniumConfig.SERVER_CONFIG_TYPES.method_10221(managedConfig);
            if (key == null) {
                this.logger.warn("Managed config {} is unregistered, can't sync!", (Object)((ServerConfig)managedConfig.serverConfig).configName);
                break;
            }
            buf.method_10812(key);
            if (this.copy) {
                ((ServerConfig)managedConfig.getCopy()).writeToPacket(buf);
                continue;
            }
            ((ServerConfig)managedConfig.serverConfig).writeToPacket(buf);
        }
        buf.method_10812(new class_2960("empty"));
    }

    @Override
    public void loadFromPacket(class_2540 buf) {
        super.loadFromPacket(buf);
        try {
            class_2960 id;
            while (!"minecraft:empty".equals((id = buf.method_10810()).toString())) {
                ServerConfigType type = (ServerConfigType)PlutoniumConfig.SERVER_CONFIG_TYPES.method_10223(id);
                if (type == null || !type.isManaged()) {
                    throw new IllegalStateException();
                }
                if (this.copy) {
                    type.updateCopy(buf);
                } else {
                    type.updateOriginal(buf);
                }
                if (this.managedConfigs.contains(type) || !this.copy) continue;
                this.managedConfigs.add(type);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, AbstractConfig.OptionInstance> getFields() {
        HashMap<String, AbstractConfig.OptionInstance> allFields = new HashMap<String, AbstractConfig.OptionInstance>(super.getFields());
        for (ServerConfigType<?> config : this.managedConfigs) {
            if (this.copy) {
                allFields.putAll(((ServerConfig)config.getCopy()).fields);
                continue;
            }
            allFields.putAll(((ServerConfig)config.serverConfig).fields);
        }
        return ImmutableMap.copyOf(allFields);
    }
}

