package ml.pluto7073.teatime.action;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.addition.action.OnDrinkAction;
import ml.pluto7073.pdapi.addition.action.OnDrinkSerializer;
import ml.pluto7073.teatime.TeaTime;
import ml.pluto7073.teatime.teatypes.TeaType;
import ml.pluto7073.teatime.teatypes.TeaTypeManager;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import java.util.List;

public class AddTeaEffectsAction implements OnDrinkAction {

    private final class_5321<TeaType> type;

    public AddTeaEffectsAction(class_5321<TeaType> type) {
        this.type = type;
    }

    @Override
    public void onDrink(class_1799 stack, class_1937 level, class_1309 user) {
        List<class_1293> list = TeaTypeManager.get(type).getEffects();
        list.forEach(user::method_6092);
    }

    @Override
    public OnDrinkSerializer<?> serializer() {
        return TeaTimeActions.ADD_TEA_EFFECTS;
    }

    public static class Serializer implements OnDrinkSerializer<AddTeaEffectsAction> {

        public static final Codec<AddTeaEffectsAction> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(class_5321.method_39154(TeaTypeManager.TEA_TYPE).fieldOf("tea")
                                .forGetter(a -> a.type))
                        .apply(instance, AddTeaEffectsAction::new));

        @Override
        public Codec<AddTeaEffectsAction> codec() {
            return CODEC;
        }

        @Override
        public AddTeaEffectsAction fromNetwork(class_2540 buf) {
            return new AddTeaEffectsAction(buf.method_44112(TeaTypeManager.TEA_TYPE));
        }

        @Override
        public void toNetwork(class_2540 buf, AddTeaEffectsAction action) {
            buf.method_44116(action.type);
        }
    }

}
