package ml.pluto7073.teatime.block;

import ml.pluto7073.teatime.block.entity.ModBlockEntityTypes;
import ml.pluto7073.teatime.block.entity.SteamerBlockEntity;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
@class_6328
public class SteamerBlock extends class_2237 {

    protected static final class_265 SHAPE;

    public SteamerBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        } else {
            this.openScreen(level, pos, player);
            return class_1269.field_21466;
        }
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        if (stack.method_7938()) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof SteamerBlockEntity steamerEntity) {
                steamerEntity.method_17488(stack.method_7964());
            }
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof SteamerBlockEntity steamerEntity) {
                if (level instanceof class_3218) {
                    class_1264.method_5451(level, pos, steamerEntity);
                }

                level.method_8455(pos, this);
            }
            super.method_9536(state, level, pos, newState, movedByPiston);
        }
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return class_1703.method_7608(level.method_8321(pos));
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        double x = pos.method_10263() + 0.4 + (double) random.method_43057() * 0.2;
        double y = pos.method_10264() + 0.3 + (double) random.method_43057() * 0.3;
        double z = pos.method_10260() + 0.4 + (double) random.method_43057() * 0.2;
        class_2586 entity = level.method_8321(pos);
        if (entity instanceof SteamerBlockEntity steamerBlockEntity) {
            if (steamerBlockEntity.isBoiling(pos, level)) {
                level.method_8406(class_2398.field_11202, x, y, z, 0.0, 0.0, 0.0);
                if (random.method_43058() < 0.1) {
                    level.method_8486(x, y, z, class_3417.field_15161, class_3419.field_15245, 1.0F, 1.0F, false);
                }
            }
        }
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SteamerBlockEntity(pos, state);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.field_9236 ? null : method_31618(type, ModBlockEntityTypes.STEAMER_TYPE, SteamerBlockEntity::tick);
    }

    protected void openScreen(class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8321(pos) instanceof SteamerBlockEntity blockEntity) {
            player.method_17355(blockEntity);
            //TODO Stats.INTERACT_WITH_STEAMER
        }
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2680 floor = level.method_8320(pos.method_10074());
        return floor.method_26164(class_3481.field_23799);
    }

    static {
        SHAPE = class_259.method_17786(
                /*Middle Bar*/ class_2248.method_9541(1, 7, 7, 15, 9, 9),
                /*West Leg*/class_2248.method_9541(0, -16, 7, 1, 10, 9),
                /*East Leg*/class_2248.method_9541(15, -16, 7, 16, 10, 9),
                /*Steamer*/class_2248.method_9541(2, -3, 2, 14, 3, 14));
    }

}
