package ml.pluto7073.teatime.compat.rei;

import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import ml.pluto7073.pdapi.PDAPI;
import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.teatypes.TeaType;
import ml.pluto7073.teatime.teatypes.TeaTypeManager;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import org.apache.commons.compress.utils.Lists;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TeaREI implements REIClientPlugin {

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        List<class_1799> bags = new ArrayList<>();
        for (TeaType tea : TeaTypeManager.values()) {
            if (Objects.equals(TeaTypeManager.getId(tea), PDAPI.asId("herbal"))) continue;
            List<class_1792> ingredients = Lists.newArrayList(tea.getIngredients().iterator());
            ingredients.add(0, class_1802.field_8276);
            ingredients.add(0, class_1802.field_8407);
            class_1799 teaBag = TeaTimeUtils.setTeaType(new class_1799(ModItems.TEA_BAG), tea);
            bags.add(teaBag);
            DefaultCustomShapelessDisplay display = DefaultCustomShapelessDisplay.simple(
                    ingredients.stream().map(EntryIngredients::of).toList(),
                    List.of(EntryIngredients.of(teaBag)),
                    Optional.empty()
            );
            registry.add(display);
        }

        class_1799 water = new class_1799(class_1802.field_8574);
        class_1844.method_8061(water, class_1847.field_8991);
        registry.add(DefaultCustomShapelessDisplay.simple(
                List.of(
                        EntryIngredients.of(water),
                        EntryIngredients.ofItemStacks(bags)
                ),
                List.of(EntryIngredients.of(ModItems.TEA)),
                Optional.empty()
        ));
    }

}
