package ml.pluto7073.teatime.mixin;

import ml.pluto7073.teatime.TeaTime;
import ml.pluto7073.teatime.recipe.DriedTeaLeaves;
import ml.pluto7073.teatime.recipe.DriedTeaLeavesBlasting;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2609;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2609.class)
public abstract class AbstractFurnaceEntityMixin {

    @Inject(at = @At("RETURN"), method = "canBurn", cancellable = true)
    private static void teatime_isRecipeTeaLeaf(class_5455 registryAccess, @Nullable class_1860<?> recipe, class_2371<class_1799> inventory, int maxStackSize, CallbackInfoReturnable<Boolean> cir) {
        if (inventory.get(0).method_7960() || recipe == null) {
            cir.setReturnValue(false);
            return;
        }
        if (recipe instanceof DriedTeaLeaves dtlRecipe) {
            class_1799 input = inventory.get(0);
            if (!TeaTimeUtils.hasDryingResult(input)) {
                return;
            }
            class_1799 outSlot = inventory.get(2);

            class_1799 output = dtlRecipe.craft(inventory);
            if (outSlot.method_7960()) {
                cir.setReturnValue(true);
            } else if (!output.method_31574(outSlot.method_7909())) {
                cir.setReturnValue(false);
            } else if (outSlot.method_7947() < maxStackSize && outSlot.method_7947() < outSlot.method_7914()) {
                cir.setReturnValue(true);
            } else {
                cir.setReturnValue(outSlot.method_7947() < output.method_7914());
            }
        } else if (recipe instanceof DriedTeaLeavesBlasting dtlBlasting) {
            class_1799 input = inventory.get(0);
            if (!TeaTimeUtils.hasDryingResult(input)) {
                return;
            }
            class_1799 outSlot = inventory.get(2);

            class_1799 output = dtlBlasting.craft(inventory);
            if (outSlot.method_7960()) {
                cir.setReturnValue(true);
            } else if (!output.method_31574(outSlot.method_7909())) {
                cir.setReturnValue(false);
            } else if (outSlot.method_7947() < maxStackSize && outSlot.method_7947() < outSlot.method_7914()) {
                cir.setReturnValue(true);
            } else {
                cir.setReturnValue(outSlot.method_7947() < output.method_7914());
            }
        }
    }

    @Inject(at = @At("HEAD"), method = "burn", cancellable = true)
    private static void teatime_craftTeaLeaves(class_5455 registryAccess, @Nullable class_1860<?> recipe, class_2371<class_1799> inventory, int maxStackSize, CallbackInfoReturnable<Boolean> cir) {
        if (recipe instanceof DriedTeaLeaves dtlRecipe) {
            class_1799 output = dtlRecipe.craft(inventory);
            class_1799 outputSlot = inventory.get(2);
            if (outputSlot.method_7960()) {
                inventory.set(2, output.method_7972());
            } else if (outputSlot.method_31574(output.method_7909())) {
                outputSlot.method_7933(1);
            }
            inventory.get(0).method_7934(1);
            cir.setReturnValue(true);
        } else if (recipe instanceof DriedTeaLeavesBlasting dtlBlasting) {
            class_1799 output = dtlBlasting.craft(inventory);
            class_1799 outputSlot = inventory.get(2);
            if (outputSlot.method_7960()) {
                inventory.set(2, output.method_7972());
            } else if (outputSlot.method_31574(output.method_7909())) {
                outputSlot.method_7933(1);
            }
            inventory.get(0).method_7934(1);
            cir.setReturnValue(true);
        }
    }

}
